/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface BoundListOperations<K, V>
extends BoundKeyOperations<K> {
    @Nullable
    public List<V> range(long var1, long var3);

    public void trim(long var1, long var3);

    @Nullable
    public Long size();

    @Nullable
    public Long leftPush(V var1);

    @Nullable
    public Long leftPushAll(V ... var1);

    @Nullable
    public Long leftPushIfPresent(V var1);

    @Nullable
    public Long leftPush(V var1, V var2);

    @Nullable
    public Long rightPush(V var1);

    @Nullable
    public Long rightPushAll(V ... var1);

    @Nullable
    public Long rightPushIfPresent(V var1);

    @Nullable
    public Long rightPush(V var1, V var2);

    @Nullable
    public V move(RedisListCommands.Direction var1, K var2, RedisListCommands.Direction var3);

    @Nullable
    public V move(RedisListCommands.Direction var1, K var2, RedisListCommands.Direction var3, Duration var4);

    @Nullable
    public V move(RedisListCommands.Direction var1, K var2, RedisListCommands.Direction var3, long var4, TimeUnit var6);

    public void set(long var1, V var3);

    @Nullable
    public Long remove(long var1, Object var3);

    @Nullable
    public V index(long var1);

    public Long indexOf(V var1);

    public Long lastIndexOf(V var1);

    @Nullable
    public V leftPop();

    @Nullable
    public List<V> leftPop(long var1);

    @Nullable
    public V leftPop(long var1, TimeUnit var3);

    @Nullable
    default public V leftPop(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.leftPop(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public V rightPop();

    @Nullable
    public List<V> rightPop(long var1);

    @Nullable
    public V rightPop(long var1, TimeUnit var3);

    @Nullable
    default public V rightPop(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.rightPop(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public RedisOperations<K, V> getOperations();
}

