/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.zset;

import java.util.Arrays;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.lang.Nullable;

public class DefaultTuple
implements Tuple {
    private final Double score;
    private final byte[] value;

    public DefaultTuple(byte[] value, Double score) {
        this.score = score;
        this.value = value;
    }

    @Override
    public Double getScore() {
        return this.score;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultTuple)) {
            return false;
        }
        DefaultTuple other = (DefaultTuple)obj;
        if (this.score == null ? other.score != null : !this.score.equals(other.score)) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.score == null ? 0 : this.score.hashCode());
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    public int compareTo(Double o) {
        Double d = this.score == null ? Double.valueOf(0.0) : this.score;
        Double a = o == null ? Double.valueOf(0.0) : o;
        return d.compareTo(a);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [score=").append(this.score);
        sb.append(", value=").append(this.value == null ? "null" : new String(this.value));
        sb.append(']');
        return sb.toString();
    }
}

