/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisClusterConfiguration
implements RedisConfiguration,
RedisConfiguration.ClusterConfiguration {
    private static final String REDIS_CLUSTER_NODES_CONFIG_PROPERTY = "spring.redis.cluster.nodes";
    private static final String REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY = "spring.redis.cluster.max-redirects";
    private Set<RedisNode> clusterNodes;
    @Nullable
    private Integer maxRedirects;
    @Nullable
    private String username = null;
    private RedisPassword password = RedisPassword.none();

    public RedisClusterConfiguration() {
        this((PropertySource<?>)new MapPropertySource("RedisClusterConfiguration", Collections.emptyMap()));
    }

    public RedisClusterConfiguration(Collection<String> clusterNodes) {
        this((PropertySource<?>)new MapPropertySource("RedisClusterConfiguration", RedisClusterConfiguration.asMap(clusterNodes, -1)));
    }

    public RedisClusterConfiguration(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null");
        this.clusterNodes = new LinkedHashSet<RedisNode>();
        if (propertySource.containsProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY)) {
            this.appendClusterNodes(StringUtils.commaDelimitedListToSet((String)propertySource.getProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY).toString()));
        }
        if (propertySource.containsProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY)) {
            this.maxRedirects = (Integer)NumberUtils.parseNumber((String)propertySource.getProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY).toString(), Integer.class);
        }
    }

    public void setClusterNodes(Iterable<RedisNode> nodes) {
        Assert.notNull(nodes, (String)"Cannot set cluster nodes to 'null'");
        this.clusterNodes.clear();
        for (RedisNode clusterNode : nodes) {
            this.addClusterNode(clusterNode);
        }
    }

    @Override
    public Set<RedisNode> getClusterNodes() {
        return Collections.unmodifiableSet(this.clusterNodes);
    }

    public void addClusterNode(RedisNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be 'null'");
        this.clusterNodes.add(node);
    }

    public RedisClusterConfiguration clusterNode(RedisNode node) {
        this.clusterNodes.add(node);
        return this;
    }

    @Override
    public Integer getMaxRedirects() {
        return this.maxRedirects != null && this.maxRedirects > Integer.MIN_VALUE ? this.maxRedirects : null;
    }

    public void setMaxRedirects(int maxRedirects) {
        Assert.isTrue((maxRedirects >= 0 ? 1 : 0) != 0, (String)"MaxRedirects must be greater or equal to 0");
        this.maxRedirects = maxRedirects;
    }

    public RedisClusterConfiguration clusterNode(String host, Integer port) {
        return this.clusterNode(new RedisNode(host, port));
    }

    private void appendClusterNodes(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addClusterNode(RedisNode.fromString(hostAndPort));
        }
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null");
        this.password = password;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisClusterConfiguration)) {
            return false;
        }
        RedisClusterConfiguration that = (RedisClusterConfiguration)o;
        if (!ObjectUtils.nullSafeEquals(this.clusterNodes, that.clusterNodes)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.maxRedirects, (Object)that.maxRedirects)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.username, (Object)that.username)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.clusterNodes);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.maxRedirects);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.username);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.password);
        return result;
    }

    private static Map<String, Object> asMap(Collection<String> clusterHostAndPorts, int redirects) {
        Assert.notNull(clusterHostAndPorts, (String)"ClusterHostAndPorts must not be null");
        Assert.noNullElements(clusterHostAndPorts, (String)"ClusterHostAndPorts must not contain null elements");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_CLUSTER_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(clusterHostAndPorts));
        if (redirects >= 0) {
            map.put(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY, redirects);
        }
        return map;
    }
}

