/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.util.RedisAssertions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisCacheManager
extends AbstractTransactionSupportingCacheManager {
    protected static final boolean DEFAULT_ALLOW_RUNTIME_CACHE_CREATION = true;
    private final boolean allowRuntimeCacheCreation;
    private final RedisCacheConfiguration defaultCacheConfiguration;
    private final RedisCacheWriter cacheWriter;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;

    public static RedisCacheManagerBuilder builder() {
        return new RedisCacheManagerBuilder();
    }

    public static RedisCacheManagerBuilder builder(RedisCacheWriter cacheWriter) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null");
        return RedisCacheManagerBuilder.fromCacheWriter(cacheWriter);
    }

    public static RedisCacheManagerBuilder builder(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        return RedisCacheManagerBuilder.fromConnectionFactory(connectionFactory);
    }

    public static RedisCacheManager create(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        return new RedisCacheManager(RedisCacheWriter.nonLockingRedisCacheWriter(connectionFactory), RedisCacheConfiguration.defaultCacheConfig());
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        this(cacheWriter, defaultCacheConfiguration, true);
    }

    private RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowRuntimeCacheCreation) {
        this.defaultCacheConfiguration = RedisAssertions.requireObject(defaultCacheConfiguration, "DefaultCacheConfiguration must not be null", new Object[0]);
        this.cacheWriter = RedisAssertions.requireObject(cacheWriter, "CacheWriter must not be null", new Object[0]);
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
        this.allowRuntimeCacheCreation = allowRuntimeCacheCreation;
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, true, initialCacheNames);
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowRuntimeCacheCreation, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, allowRuntimeCacheCreation);
        for (String cacheName : initialCacheNames) {
            this.initialCacheConfiguration.put(cacheName, defaultCacheConfiguration);
        }
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration, true, initialCacheConfigurations);
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowRuntimeCacheCreation, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration, allowRuntimeCacheCreation);
        Assert.notNull(initialCacheConfigurations, (String)"InitialCacheConfigurations must not be null");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    @Deprecated
    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowRuntimeCacheCreation) {
        this(cacheWriter, defaultCacheConfiguration, allowRuntimeCacheCreation, initialCacheConfigurations);
    }

    public boolean isAllowRuntimeCacheCreation() {
        return this.allowRuntimeCacheCreation;
    }

    public Map<String, RedisCacheConfiguration> getCacheConfigurations() {
        HashMap cacheConfigurationMap = new HashMap(this.getCacheNames().size());
        this.getCacheNames().forEach(cacheName -> {
            RedisCache cache = (RedisCache)this.lookupCache((String)cacheName);
            cacheConfigurationMap.put(cacheName, cache != null ? cache.getCacheConfiguration() : null);
        });
        return Collections.unmodifiableMap(cacheConfigurationMap);
    }

    protected RedisCacheConfiguration getDefaultCacheConfiguration() {
        return this.defaultCacheConfiguration;
    }

    protected Map<String, RedisCacheConfiguration> getInitialCacheConfiguration() {
        return Collections.unmodifiableMap(this.initialCacheConfiguration);
    }

    protected RedisCache getMissingCache(String name) {
        return this.isAllowRuntimeCacheCreation() ? this.createRedisCache(name, this.getDefaultCacheConfiguration()) : null;
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfiguration) {
        return new RedisCache(name, this.cacheWriter, this.resolveCacheConfiguration(cacheConfiguration));
    }

    protected Collection<RedisCache> loadCaches() {
        return this.getInitialCacheConfiguration().entrySet().stream().map(entry -> this.createRedisCache((String)entry.getKey(), (RedisCacheConfiguration)entry.getValue())).collect(Collectors.toList());
    }

    private RedisCacheConfiguration resolveCacheConfiguration(@Nullable RedisCacheConfiguration cacheConfiguration) {
        return cacheConfiguration != null ? cacheConfiguration : this.getDefaultCacheConfiguration();
    }

    public static class RedisCacheManagerBuilder {
        private boolean allowRuntimeCacheCreation = true;
        private boolean enableTransactions;
        private CacheStatisticsCollector statisticsCollector = CacheStatisticsCollector.none();
        private final Map<String, RedisCacheConfiguration> initialCaches = new LinkedHashMap<String, RedisCacheConfiguration>();
        private RedisCacheConfiguration defaultCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        @Nullable
        private RedisCacheWriter cacheWriter;

        public static RedisCacheManagerBuilder fromCacheWriter(RedisCacheWriter cacheWriter) {
            return new RedisCacheManagerBuilder(RedisAssertions.requireObject(cacheWriter, "CacheWriter must not be null", new Object[0]));
        }

        public static RedisCacheManagerBuilder fromConnectionFactory(RedisConnectionFactory connectionFactory) {
            RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter(RedisAssertions.requireObject(connectionFactory, "ConnectionFactory must not be null", new Object[0]));
            return new RedisCacheManagerBuilder(cacheWriter);
        }

        private RedisCacheManagerBuilder() {
        }

        private RedisCacheManagerBuilder(RedisCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public RedisCacheManagerBuilder allowCreateOnMissingCache(boolean allowRuntimeCacheCreation) {
            this.allowRuntimeCacheCreation = allowRuntimeCacheCreation;
            return this;
        }

        public RedisCacheManagerBuilder disableCreateOnMissingCache() {
            return this.allowCreateOnMissingCache(false);
        }

        public RedisCacheManagerBuilder enableCreateOnMissingCache() {
            return this.allowCreateOnMissingCache(true);
        }

        public RedisCacheConfiguration cacheDefaults() {
            return this.defaultCacheConfiguration;
        }

        public RedisCacheManagerBuilder cacheDefaults(RedisCacheConfiguration defaultCacheConfiguration) {
            this.defaultCacheConfiguration = RedisAssertions.requireObject(defaultCacheConfiguration, "DefaultCacheConfiguration must not be null", new Object[0]);
            return this;
        }

        public RedisCacheManagerBuilder cacheWriter(RedisCacheWriter cacheWriter) {
            this.cacheWriter = RedisAssertions.requireObject(cacheWriter, "CacheWriter must not be null", new Object[0]);
            return this;
        }

        public RedisCacheManagerBuilder enableStatistics() {
            this.statisticsCollector = CacheStatisticsCollector.create();
            return this;
        }

        public RedisCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            RedisAssertions.requireObject(cacheNames, "CacheNames must not be null", new Object[0]).forEach(it -> this.withCacheConfiguration((String)it, this.defaultCacheConfiguration));
            return this;
        }

        public RedisCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public RedisCacheManagerBuilder withCacheConfiguration(String cacheName, RedisCacheConfiguration cacheConfiguration) {
            Assert.notNull((Object)cacheName, (String)"CacheName must not be null");
            Assert.notNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null");
            this.initialCaches.put(cacheName, cacheConfiguration);
            return this;
        }

        public RedisCacheManagerBuilder withInitialCacheConfigurations(Map<String, RedisCacheConfiguration> cacheConfigurations) {
            RedisAssertions.requireObject(cacheConfigurations, "CacheConfigurations must not be null", new Object[0]).forEach((cacheName, cacheConfiguration) -> RedisAssertions.requireObject(cacheConfiguration, "RedisCacheConfiguration for cache [%s] must not be null", cacheName));
            this.initialCaches.putAll(cacheConfigurations);
            return this;
        }

        public Optional<RedisCacheConfiguration> getCacheConfigurationFor(String cacheName) {
            return Optional.ofNullable(this.initialCaches.get(cacheName));
        }

        public Set<String> getConfiguredCaches() {
            return Collections.unmodifiableSet(this.initialCaches.keySet());
        }

        public RedisCacheManager build() {
            Assert.state((this.cacheWriter != null ? 1 : 0) != 0, (String)"CacheWriter must not be null; You can provide one via 'RedisCacheManagerBuilder#cacheWriter(RedisCacheWriter)'");
            RedisCacheWriter resolvedCacheWriter = !CacheStatisticsCollector.none().equals(this.statisticsCollector) ? this.cacheWriter.withStatisticsCollector(this.statisticsCollector) : this.cacheWriter;
            RedisCacheManager cacheManager = this.newRedisCacheManager(resolvedCacheWriter);
            cacheManager.setTransactionAware(this.enableTransactions);
            return cacheManager;
        }

        private RedisCacheManager newRedisCacheManager(RedisCacheWriter cacheWriter) {
            return new RedisCacheManager(cacheWriter, this.cacheDefaults(), this.allowRuntimeCacheCreation, this.initialCaches);
        }
    }
}

