/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.time.Duration;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.RecordId;

public class PendingMessage {
    private final RecordId id;
    private final Consumer consumer;
    private final Duration elapsedTimeSinceLastDelivery;
    private final Long totalDeliveryCount;

    public PendingMessage(RecordId id, Consumer consumer, Duration elapsedTimeSinceLastDelivery, long totalDeliveryCount) {
        this.id = id;
        this.consumer = consumer;
        this.elapsedTimeSinceLastDelivery = elapsedTimeSinceLastDelivery;
        this.totalDeliveryCount = totalDeliveryCount;
    }

    public RecordId getId() {
        return this.id;
    }

    public String getIdAsString() {
        return this.id.getValue();
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public String getConsumerName() {
        return this.consumer.getName();
    }

    public String getGroupName() {
        return this.consumer.getGroup();
    }

    public Duration getElapsedTimeSinceLastDelivery() {
        return this.elapsedTimeSinceLastDelivery;
    }

    public long getTotalDeliveryCount() {
        return this.totalDeliveryCount;
    }

    public String toString() {
        return "PendingMessage{id=" + this.id + ", consumer=" + this.consumer + ", elapsedTimeSinceLastDeliveryMS=" + this.elapsedTimeSinceLastDelivery.toMillis() + ", totalDeliveryCount=" + this.totalDeliveryCount + '}';
    }
}

