/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceFutureUtils;
import org.springframework.lang.Nullable;

class StandaloneConnectionProvider
implements LettuceConnectionProvider,
LettuceConnectionProvider.TargetAware {
    private final RedisClient client;
    private final RedisCodec<?, ?> codec;
    private final Optional<ReadFrom> readFrom;
    private final Supplier<RedisURI> redisURISupplier;

    StandaloneConnectionProvider(RedisClient client, RedisCodec<?, ?> codec) {
        this(client, codec, null);
    }

    StandaloneConnectionProvider(final RedisClient client, RedisCodec<?, ?> codec, @Nullable ReadFrom readFrom) {
        this.client = client;
        this.codec = codec;
        this.readFrom = Optional.ofNullable(readFrom);
        this.redisURISupplier = new Supplier<RedisURI>(){
            AtomicReference<RedisURI> uriFieldReference = new AtomicReference();

            @Override
            public RedisURI get() {
                RedisURI uri = this.uriFieldReference.get();
                if (uri != null) {
                    return uri;
                }
                uri = (RedisURI)RedisURI.class.cast(new DirectFieldAccessor((Object)client).getPropertyValue("redisURI"));
                return this.uriFieldReference.compareAndSet(null, uri) ? uri : this.uriFieldReference.get();
            }
        };
    }

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        if (connectionType.equals(StatefulRedisSentinelConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectSentinel()));
        }
        if (connectionType.equals(StatefulRedisPubSubConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectPubSub(this.codec)));
        }
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            return (T)((StatefulConnection)connectionType.cast(this.readFrom.map(it -> this.masterReplicaConnection(this.redisURISupplier.get(), (ReadFrom)it)).orElseGet(() -> this.client.connect(this.codec))));
        }
        throw new UnsupportedOperationException("Connection type " + connectionType + " not supported!");
    }

    @Override
    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
        return this.getConnectionAsync(connectionType, this.redisURISupplier.get());
    }

    @Override
    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType, RedisURI redisURI) {
        if (connectionType.equals(StatefulRedisSentinelConnection.class)) {
            return this.client.connectSentinelAsync((RedisCodec)StringCodec.UTF8, redisURI).thenApply(connectionType::cast);
        }
        if (connectionType.equals(StatefulRedisPubSubConnection.class)) {
            return this.client.connectPubSubAsync(this.codec, redisURI).thenApply(connectionType::cast);
        }
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            return this.readFrom.map(it -> this.masterReplicaConnectionAsync(redisURI, (ReadFrom)it)).orElseGet(() -> this.client.connectAsync(this.codec, redisURI)).thenApply(connectionType::cast);
        }
        return LettuceFutureUtils.failed(new UnsupportedOperationException("Connection type " + connectionType + " not supported!"));
    }

    private StatefulRedisConnection masterReplicaConnection(RedisURI redisUri, ReadFrom readFrom) {
        StatefulRedisMasterReplicaConnection connection = MasterReplica.connect((RedisClient)this.client, this.codec, (RedisURI)redisUri);
        connection.setReadFrom(readFrom);
        return connection;
    }

    private CompletionStage<StatefulRedisConnection<?, ?>> masterReplicaConnectionAsync(RedisURI redisUri, ReadFrom readFrom) {
        CompletableFuture connection = MasterReplica.connectAsync((RedisClient)this.client, this.codec, (RedisURI)redisUri);
        return connection.thenApply(conn -> {
            conn.setReadFrom(readFrom);
            return conn;
        });
    }
}

