/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactivePubSubCommands;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.ReactiveServerCommands;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.ReactiveStreamCommands;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public interface ReactiveRedisConnection
extends Closeable {
    @Override
    default public void close() {
        this.closeLater().block();
    }

    public Mono<Void> closeLater();

    public ReactiveKeyCommands keyCommands();

    public ReactiveStringCommands stringCommands();

    public ReactiveNumberCommands numberCommands();

    public ReactiveListCommands listCommands();

    public ReactiveSetCommands setCommands();

    public ReactiveZSetCommands zSetCommands();

    public ReactiveHashCommands hashCommands();

    public ReactiveGeoCommands geoCommands();

    public ReactiveHyperLogLogCommands hyperLogLogCommands();

    public ReactivePubSubCommands pubSubCommands();

    public ReactiveScriptingCommands scriptingCommands();

    public ReactiveServerCommands serverCommands();

    public ReactiveStreamCommands streamCommands();

    public Mono<String> ping();

    public static class NumericResponse<I, O extends Number>
    extends CommandResponse<I, O> {
        public NumericResponse(I input, O output) {
            super(input, output);
        }
    }

    public static class MultiValueResponse<I, O>
    extends CommandResponse<I, List<O>> {
        public MultiValueResponse(I input, List<O> output) {
            super(input, output);
        }
    }

    public static class AbsentByteBufferResponse<I>
    extends ByteBufferResponse<I> {
        private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);

        public AbsentByteBufferResponse(I input) {
            super(input, EMPTY_BYTE_BUFFER);
        }

        @Override
        public boolean isPresent() {
            return false;
        }
    }

    public static class ByteBufferResponse<I>
    extends CommandResponse<I, ByteBuffer> {
        public ByteBufferResponse(I input, @Nullable ByteBuffer output) {
            super(input, output);
        }
    }

    public static class BooleanResponse<I>
    extends CommandResponse<I, Boolean> {
        public BooleanResponse(I input, Boolean output) {
            super(input, output);
        }
    }

    public static class CommandResponse<I, O> {
        private final I input;
        @Nullable
        private final O output;

        public CommandResponse(I input, @Nullable O output) {
            this.input = input;
            this.output = output;
        }

        public boolean isPresent() {
            return true;
        }

        public I getInput() {
            return this.input;
        }

        @Nullable
        public O getOutput() {
            return this.output;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandResponse that = (CommandResponse)o;
            if (!ObjectUtils.nullSafeEquals(this.input, that.input)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.output, that.output);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.input);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.output);
            return result;
        }

        public String toString() {
            return "ReactiveRedisConnection.CommandResponse(input=" + this.getInput() + ", output=" + this.getOutput() + ")";
        }
    }

    public static class RangeCommand
    extends KeyCommand {
        Range<Long> range;

        private RangeCommand(ByteBuffer key, Range<Long> range) {
            super(key);
            this.range = range;
        }

        public static RangeCommand key(ByteBuffer key) {
            return new RangeCommand(key, (Range<Long>)Range.unbounded());
        }

        public RangeCommand within(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new RangeCommand(this.getKey(), range);
        }

        public RangeCommand fromIndex(long start) {
            return new RangeCommand(this.getKey(), (Range<Long>)Range.of((Range.Bound)Range.Bound.inclusive((long)start), (Range.Bound)this.range.getUpperBound()));
        }

        public RangeCommand toIndex(long end) {
            return new RangeCommand(this.getKey(), (Range<Long>)Range.of((Range.Bound)this.range.getLowerBound(), (Range.Bound)Range.Bound.inclusive((long)end)));
        }

        public Range<Long> getRange() {
            return this.range;
        }
    }

    public static class KeyScanCommand
    extends KeyCommand {
        private final ScanOptions options;

        private KeyScanCommand(@Nullable ByteBuffer key, ScanOptions options) {
            super(key);
            Assert.notNull((Object)options, (String)"ScanOptions must not be null!");
            this.options = options;
        }

        public static KeyScanCommand key(ByteBuffer key) {
            return new KeyScanCommand(key, ScanOptions.NONE);
        }

        public KeyScanCommand withOptions(ScanOptions options) {
            return new KeyScanCommand(this.getKey(), options);
        }

        public ScanOptions getOptions() {
            return this.options;
        }
    }

    public static class KeyCommand
    implements Command {
        @Nullable
        private ByteBuffer key;

        public KeyCommand(@Nullable ByteBuffer key) {
            this.key = key;
        }

        @Override
        public ByteBuffer getKey() {
            return this.key;
        }
    }

    public static interface Command {
        @Nullable
        public ByteBuffer getKey();

        default public String getName() {
            return this.getClass().getSimpleName().replace("Command", "").toUpperCase();
        }
    }
}

