/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.ReactiveRedisCallback;
import org.springframework.data.redis.core.script.ReactiveScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptUtils;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class DefaultReactiveScriptExecutor<K>
implements ReactiveScriptExecutor<K> {
    private final ReactiveRedisConnectionFactory connectionFactory;
    private final RedisSerializationContext<K, ?> serializationContext;

    public DefaultReactiveScriptExecutor(ReactiveRedisConnectionFactory connectionFactory, RedisSerializationContext<K, ?> serializationContext) {
        Assert.notNull((Object)connectionFactory, (String)"ReactiveRedisConnectionFactory must not be null!");
        Assert.notNull(serializationContext, (String)"RedisSerializationContext must not be null!");
        this.connectionFactory = connectionFactory;
        this.serializationContext = serializationContext;
    }

    @Override
    public <T> Flux<T> execute(RedisScript<T> script, List<K> keys, List<?> args) {
        Assert.notNull(script, (String)"RedisScript must not be null!");
        Assert.notNull(keys, (String)"Keys must not be null!");
        Assert.notNull(args, (String)"Args must not be null!");
        RedisSerializationContext.SerializationPair<?> serializationPair = this.serializationContext.getValueSerializationPair();
        return this.execute(script, keys, args, serializationPair.getWriter(), serializationPair.getReader());
    }

    @Override
    public <T> Flux<T> execute(RedisScript<T> script, List<K> keys, List<?> args, RedisElementWriter<?> argsWriter, RedisElementReader<T> resultReader) {
        Assert.notNull(script, (String)"RedisScript must not be null!");
        Assert.notNull(argsWriter, (String)"Argument Writer must not be null!");
        Assert.notNull(resultReader, (String)"Result Reader must not be null!");
        Assert.notNull(keys, (String)"Keys must not be null!");
        Assert.notNull(args, (String)"Args must not be null!");
        return this.execute((ReactiveRedisConnection connection) -> {
            ReturnType returnType = ReturnType.fromJavaType(script.getResultType());
            ByteBuffer[] keysAndArgs = this.keysAndArgs(argsWriter, keys, args);
            int keySize = keys.size();
            return this.eval(connection, script, returnType, keySize, keysAndArgs, resultReader);
        });
    }

    protected <T> Flux<T> eval(ReactiveRedisConnection connection, RedisScript<T> script, ReturnType returnType, int numKeys, ByteBuffer[] keysAndArgs, RedisElementReader<T> resultReader) {
        Flux<T> result = connection.scriptingCommands().evalSha(script.getSha1(), returnType, numKeys, keysAndArgs);
        result = result.onErrorResume(e -> {
            if (ScriptUtils.exceptionContainsNoScriptError(e)) {
                return connection.scriptingCommands().eval(this.scriptBytes(script), returnType, numKeys, keysAndArgs);
            }
            return Flux.error((Throwable)(e instanceof RuntimeException ? (RuntimeException)e : new RedisSystemException(e.getMessage(), (Throwable)e)));
        });
        return script.returnsRawValue() ? result : this.deserializeResult(resultReader, result);
    }

    protected ByteBuffer[] keysAndArgs(RedisElementWriter argsWriter, List<K> keys, List<?> args) {
        return (ByteBuffer[])Stream.concat(keys.stream().map(t -> this.keySerializer().getWriter().write(t)), args.stream().map(t -> argsWriter.write(t))).toArray(ByteBuffer[]::new);
    }

    protected ByteBuffer scriptBytes(RedisScript<?> script) {
        return this.serializationContext.getStringSerializationPair().getWriter().write(script.getScriptAsString());
    }

    protected <T> Flux<T> deserializeResult(RedisElementReader<T> reader, Flux<T> result) {
        return result.map(it -> ScriptUtils.deserializeResult(reader, it));
    }

    protected RedisSerializationContext.SerializationPair<K> keySerializer() {
        return this.serializationContext.getKeySerializationPair();
    }

    @Override
    private <T> Flux<T> execute(ReactiveRedisCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        ReactiveRedisConnectionFactory factory = this.getConnectionFactory();
        ReactiveRedisConnection conn = factory.getReactiveConnection();
        try {
            return Flux.defer(() -> action.doInRedis(conn)).doFinally(signal -> conn.close());
        }
        catch (RuntimeException e) {
            conn.close();
            throw e;
        }
    }

    public ReactiveRedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

