/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisConfiguration {
    default public Integer getDatabaseOrElse(Supplier<Integer> other) {
        return RedisConfiguration.getDatabaseOrElse(this, other);
    }

    default public RedisPassword getPasswordOrElse(Supplier<RedisPassword> other) {
        return RedisConfiguration.getPasswordOrElse(this, other);
    }

    public static boolean isPasswordAware(@Nullable RedisConfiguration configuration) {
        return configuration instanceof WithPassword;
    }

    public static boolean isDatabaseIndexAware(@Nullable RedisConfiguration configuration) {
        return configuration instanceof WithDatabaseIndex;
    }

    public static boolean isSentinelConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof SentinelConfiguration;
    }

    public static boolean isClusterConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof ClusterConfiguration;
    }

    public static boolean isStaticMasterReplicaConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof StaticMasterReplicaConfiguration;
    }

    public static boolean isDomainSocketConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof DomainSocketConfiguration;
    }

    public static Integer getDatabaseOrElse(@Nullable RedisConfiguration configuration, Supplier<Integer> other) {
        Assert.notNull(other, (String)"Other must not be null!");
        return RedisConfiguration.isDatabaseIndexAware(configuration) ? Integer.valueOf(((WithDatabaseIndex)((Object)configuration)).getDatabase()) : other.get();
    }

    public static RedisPassword getPasswordOrElse(@Nullable RedisConfiguration configuration, Supplier<RedisPassword> other) {
        Assert.notNull(other, (String)"Other must not be null!");
        return RedisConfiguration.isPasswordAware(configuration) ? ((WithPassword)((Object)configuration)).getPassword() : other.get();
    }

    public static interface DomainSocketConfiguration
    extends WithDomainSocket,
    WithDatabaseIndex,
    WithPassword {
    }

    public static interface StaticMasterReplicaConfiguration
    extends WithDatabaseIndex,
    WithPassword {
        public List<RedisStandaloneConfiguration> getNodes();
    }

    public static interface ClusterConfiguration
    extends WithPassword {
        public Set<RedisNode> getClusterNodes();

        @Nullable
        public Integer getMaxRedirects();
    }

    public static interface SentinelConfiguration
    extends WithDatabaseIndex,
    WithPassword {
        default public void setMaster(String name) {
            Assert.notNull((Object)name, (String)"Name of sentinel master must not be null.");
            this.setMaster(() -> name);
        }

        public void setMaster(NamedNode var1);

        @Nullable
        public NamedNode getMaster();

        public Set<RedisNode> getSentinels();
    }

    public static interface WithDomainSocket {
        public void setSocket(String var1);

        public String getSocket();
    }

    public static interface WithHostAndPort {
        public void setHostName(String var1);

        public String getHostName();

        public void setPort(int var1);

        public int getPort();
    }

    public static interface WithDatabaseIndex {
        public void setDatabase(int var1);

        public int getDatabase();
    }

    public static interface WithPassword {
        default public void setPassword(@Nullable String password) {
            this.setPassword(RedisPassword.of(password));
        }

        default public void setPassword(@Nullable char[] password) {
            this.setPassword(RedisPassword.of(password));
        }

        public void setPassword(RedisPassword var1);

        public RedisPassword getPassword();
    }
}

