/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.data.redis.connection.lettuce.LettuceSentinelConnection;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class LettuceConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    public static final String PING_REPLY = "PONG";
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    private final Log log = LogFactory.getLog(this.getClass());
    private String hostName = "localhost";
    private int port = 6379;
    private AbstractRedisClient client;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private long shutdownTimeout = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS);
    private boolean validateConnection = false;
    private boolean shareNativeConnection = true;
    private StatefulRedisConnection<byte[], byte[]> connection;
    private LettucePool pool;
    private int dbIndex = 0;
    private final Object connectionMonitor = new Object();
    private String password;
    private boolean convertPipelineAndTxResults = true;
    private RedisSentinelConfiguration sentinelConfiguration;
    private RedisClusterConfiguration clusterConfiguration;
    private ClusterCommandExecutor clusterCommandExecutor;
    private ClientResources clientResources;
    private boolean useSsl = false;
    private boolean verifyPeer = true;
    private boolean startTls = false;

    public LettuceConnectionFactory() {
    }

    public LettuceConnectionFactory(String host, int port) {
        this.hostName = host;
        this.port = port;
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration) {
        this.sentinelConfiguration = sentinelConfiguration;
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfig) {
        this.clusterConfiguration = clusterConfig;
    }

    public LettuceConnectionFactory(LettucePool pool) {
        this.pool = pool;
    }

    public void afterPropertiesSet() {
        this.client = this.createRedisClient();
    }

    public void destroy() {
        block5: {
            this.resetConnection();
            try {
                this.client.shutdown(this.shutdownTimeout, this.shutdownTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block5;
                this.log.warn((Object)((this.client != null ? ClassUtils.getShortName(this.client.getClass()) : "LettuceClient") + " did not shut down gracefully."), (Throwable)e);
            }
        }
        if (this.clusterCommandExecutor != null) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isClusterAware()) {
            return this.getClusterConnection();
        }
        LettuceConnection connection = new LettuceConnection(this.getSharedConnection(), this.timeout, this.client, this.pool, this.dbIndex);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return connection;
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        return new LettuceClusterConnection((RedisClusterClient)this.client, this.getTimeout(), this.clusterCommandExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.resetConnection();
            }
            this.connection = this.createLettuceConnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            boolean valid = false;
            if (this.connection.isOpen()) {
                try {
                    this.connection.sync().ping();
                    valid = true;
                }
                catch (Exception e) {
                    this.log.debug((Object)"Validation failed", (Throwable)e);
                }
            }
            if (!valid) {
                this.log.warn((Object)"Validation of shared connection failed. Creating a new connection.");
                this.initConnection();
            }
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean getShareNativeConnection() {
        return this.shareNativeConnection;
    }

    public void setShareNativeConnection(boolean shareNativeConnection) {
        this.shareNativeConnection = shareNativeConnection;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public ClientResources getClientResources() {
        return this.clientResources;
    }

    public void setClientResources(ClientResources clientResources) {
        this.clientResources = clientResources;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public boolean isRedisSentinelAware() {
        return this.sentinelConfiguration != null;
    }

    public boolean isClusterAware() {
        return this.clusterConfiguration != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulRedisConnection<byte[], byte[]> getSharedConnection() {
        if (this.shareNativeConnection) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.connection == null) {
                    this.initConnection();
                }
                if (this.validateConnection) {
                    this.validateConnection();
                }
                return this.connection;
            }
        }
        return null;
    }

    protected StatefulRedisConnection<byte[], byte[]> createLettuceConnector() {
        try {
            StatefulRedisConnection connection = null;
            if (this.client instanceof RedisClient) {
                connection = ((RedisClient)this.client).connect(LettuceConnection.CODEC);
                if (this.dbIndex > 0) {
                    connection.sync().select(this.dbIndex);
                }
            } else {
                connection = null;
            }
            return connection;
        }
        catch (RedisException e) {
            throw new RedisConnectionFailureException("Unable to connect to Redis on " + this.getHostName() + ":" + this.getPort(), e);
        }
    }

    private AbstractRedisClient createRedisClient() {
        if (this.isRedisSentinelAware()) {
            RedisURI redisURI = this.getSentinelRedisURI();
            if (this.clientResources == null) {
                return RedisClient.create((RedisURI)redisURI);
            }
            return RedisClient.create((ClientResources)this.clientResources, (RedisURI)redisURI);
        }
        if (this.isClusterAware()) {
            ArrayList<RedisURI> initialUris = new ArrayList<RedisURI>();
            for (RedisNode node : this.clusterConfiguration.getClusterNodes()) {
                initialUris.add(this.createRedisURIAndApplySettings(node.getHost(), node.getPort()));
            }
            RedisClusterClient clusterClient = this.clientResources != null ? RedisClusterClient.create((ClientResources)this.clientResources, initialUris) : RedisClusterClient.create(initialUris);
            this.clusterCommandExecutor = new ClusterCommandExecutor(new LettuceClusterConnection.LettuceClusterTopologyProvider(clusterClient), new LettuceClusterConnection.LettuceClusterNodeResourceProvider(clusterClient), EXCEPTION_TRANSLATION);
            return clusterClient;
        }
        if (this.pool != null) {
            return this.pool.getClient();
        }
        RedisURI uri = this.createRedisURIAndApplySettings(this.hostName, this.port);
        return this.clientResources != null ? RedisClient.create((ClientResources)this.clientResources, (RedisURI)uri) : RedisClient.create((RedisURI)uri);
    }

    private RedisURI getSentinelRedisURI() {
        RedisURI redisUri = LettuceConverters.sentinelConfigurationToRedisURI(this.sentinelConfiguration);
        if (StringUtils.hasText((String)this.password)) {
            redisUri.setPassword(this.password);
        }
        return redisUri;
    }

    private RedisURI createRedisURIAndApplySettings(String host, int port) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)host, (int)port);
        if (StringUtils.hasText((String)this.password)) {
            builder.withPassword(this.password);
        }
        builder.withSsl(this.useSsl);
        builder.withVerifyPeer(this.verifyPeer);
        builder.withStartTls(this.startTls);
        builder.withTimeout(this.timeout, TimeUnit.MILLISECONDS);
        return builder.build();
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        if (!(this.client instanceof RedisClient)) {
            throw new InvalidDataAccessResourceUsageException("Unable to connect to sentinels using " + this.client.getClass());
        }
        return new LettuceSentinelConnection((StatefulRedisSentinelConnection<String, String>)((RedisClient)this.client).connectSentinel());
    }
}

