/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.mapping;

import org.springframework.data.annotation.Id;
import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class BasicRedisPersistentEntity<T>
extends BasicKeyValuePersistentEntity<T>
implements RedisPersistentEntity<T> {
    private TimeToLiveAccessor timeToLiveAccessor;

    public BasicRedisPersistentEntity(TypeInformation<T> information, KeySpaceResolver fallbackKeySpaceResolver, TimeToLiveAccessor timeToLiveAccessor) {
        super(information, fallbackKeySpaceResolver);
        Assert.notNull((Object)timeToLiveAccessor, (String)"TimeToLiveAccessor must not be null");
        this.timeToLiveAccessor = timeToLiveAccessor;
    }

    @Override
    public TimeToLiveAccessor getTimeToLiveAccessor() {
        return this.timeToLiveAccessor;
    }

    protected KeyValuePersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(KeyValuePersistentProperty property) {
        boolean currentIdPropertyIsSet;
        Assert.notNull((Object)property, (String)"Property must not be null!");
        if (!property.isIdProperty()) {
            return null;
        }
        KeyValuePersistentProperty currentIdProperty = (KeyValuePersistentProperty)this.getIdProperty();
        boolean bl = currentIdPropertyIsSet = currentIdProperty != null;
        if (!currentIdPropertyIsSet) {
            return property;
        }
        boolean currentIdPropertyIsExplicit = currentIdProperty.isAnnotationPresent(Id.class);
        boolean newIdPropertyIsExplicit = property.isAnnotationPresent(Id.class);
        if (currentIdPropertyIsExplicit && newIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add explicit id property %s but already have an property %s registered as explicit id. Check your mapping configuration!", property.getField(), currentIdProperty.getField()));
        }
        if (!currentIdPropertyIsExplicit && !newIdPropertyIsExplicit) {
            throw new MappingException(String.format("Attempt to add id property %s but already have an property %s registered as id. Check your mapping configuration!", property.getField(), currentIdProperty.getField()));
        }
        if (newIdPropertyIsExplicit) {
            return property;
        }
        return null;
    }
}

