/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.neo4j.repository.support.ReactiveCypherdslConditionExecutor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.3.3")
public final class ReactiveCypherdslConditionExecutorImpl<T>
implements ReactiveCypherdslConditionExecutor<T> {
    private final Neo4jEntityInformation<T, Object> entityInformation;
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jPersistentEntity<T> metaData;

    public ReactiveCypherdslConditionExecutorImpl(Neo4jEntityInformation<T, Object> entityInformation, ReactiveNeo4jOperations neo4jOperations) {
        this.entityInformation = entityInformation;
        this.neo4jOperations = neo4jOperations;
        this.metaData = this.entityInformation.getEntityMetaData();
    }

    @Override
    public Mono<T> findOne(Condition condition) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition)).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public Flux<T> findAll(Condition condition) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public Flux<T> findAll(Condition condition, Sort sort) {
        Predicate<PropertyFilter.RelaxedPropertyPath> noFilter = PropertyFilter.NO_FILTER;
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forConditionAndSort(this.metaData, condition, sort, null, noFilter)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public Flux<T> findAll(Condition condition, SortItem ... sortItems) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forConditionAndSortItems(this.metaData, condition, Arrays.asList(sortItems))).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public Flux<T> findAll(SortItem ... sortItems) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forConditionAndSortItems(this.metaData, Cypher.noCondition(), Arrays.asList(sortItems))).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public Mono<Long> count(Condition condition) {
        Statement statement = CypherGenerator.INSTANCE.prepareMatchOf(this.metaData, condition).returning(new Expression[]{Cypher.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, (Map<String, Object>)statement.getCatalog().getParameters());
    }

    @Override
    public Mono<Boolean> exists(Condition condition) {
        return this.count(condition).map(count -> count > 0L);
    }
}

