/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.SortItem;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherdslConditionExecutorImpl;
import org.springframework.data.neo4j.repository.query.FetchableFluentQueryByPredicate;
import org.springframework.data.neo4j.repository.support.CypherdslConditionExecutor;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.FluentQuery;

@API(status=API.Status.INTERNAL, since="6.1")
public final class QuerydslNeo4jPredicateExecutor<T>
implements QuerydslPredicateExecutor<T> {
    private final CypherdslConditionExecutor<T> delegate;
    private final Neo4jOperations neo4jOperations;
    private final Neo4jPersistentEntity<T> metaData;
    private final Neo4jMappingContext mappingContext;

    public QuerydslNeo4jPredicateExecutor(Neo4jMappingContext mappingContext, Neo4jEntityInformation<T, Object> entityInformation, Neo4jOperations neo4jOperations) {
        this.mappingContext = mappingContext;
        this.delegate = new CypherdslConditionExecutorImpl<T>(entityInformation, neo4jOperations);
        this.neo4jOperations = neo4jOperations;
        this.metaData = entityInformation.getEntityMetaData();
    }

    public Optional<T> findOne(Predicate predicate) {
        return this.delegate.findOne(Cypher.adapt((Object)predicate).asCondition());
    }

    public Iterable<T> findAll(Predicate predicate) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition());
    }

    public Iterable<T> findAll(Predicate predicate, Sort sort) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition(), sort);
    }

    public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition(), QuerydslNeo4jPredicateExecutor.toSortItems(orders));
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        return this.delegate.findAll(QuerydslNeo4jPredicateExecutor.toSortItems(orders));
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition(), pageable);
    }

    public long count(Predicate predicate) {
        return this.delegate.count(Cypher.adapt((Object)predicate).asCondition());
    }

    static SortItem[] toSortItems(OrderSpecifier<?> ... orderSpecifiers) {
        return (SortItem[])Arrays.stream(orderSpecifiers).map(os -> Cypher.sort((Expression)Cypher.adapt((Object)os.getTarget()).asExpression(), (SortItem.Direction)(os.isAscending() ? SortItem.Direction.ASC : SortItem.Direction.DESC))).toArray(SortItem[]::new);
    }

    public boolean exists(Predicate predicate) {
        return this.findAll(predicate).iterator().hasNext();
    }

    public <S extends T, R> R findBy(Predicate predicate, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Neo4jOperations neo4jOperations = this.neo4jOperations;
        if (neo4jOperations instanceof FluentFindOperation) {
            FluentFindOperation ops = (FluentFindOperation)((Object)neo4jOperations);
            FetchableFluentQueryByPredicate fluentQuery = new FetchableFluentQueryByPredicate(predicate, this.mappingContext, this.metaData, this.metaData.getType(), ops, this::count, this::exists);
            return queryFunction.apply(fluentQuery);
        }
        throw new UnsupportedOperationException("Fluent find by predicate not supported with standard Neo4jOperations, must support fluent queries too");
    }
}

