/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import java.util.Set;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.reactivestreams.ReactiveSession;
import org.neo4j.driver.reactivestreams.ReactiveTransaction;
import org.reactivestreams.Publisher;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionContext;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;
import reactor.core.publisher.Mono;

final class ReactiveNeo4jTransactionHolder
extends ResourceHolderSupport {
    private final Neo4jTransactionContext context;
    private final ReactiveSession session;
    private final ReactiveTransaction transaction;

    ReactiveNeo4jTransactionHolder(Neo4jTransactionContext context, ReactiveSession session, ReactiveTransaction transaction) {
        this.context = context;
        this.session = session;
        this.transaction = transaction;
    }

    ReactiveSession getSession() {
        return this.session;
    }

    @Nullable
    ReactiveTransaction getTransaction(DatabaseSelection inDatabase, UserSelection asUser) {
        return this.context.isForDatabaseAndUser(inDatabase, asUser) ? this.transaction : null;
    }

    Mono<Set<Bookmark>> commit() {
        return Mono.fromDirect((Publisher)this.transaction.commit()).then(Mono.fromSupplier(() -> ((ReactiveSession)this.session).lastBookmarks()));
    }

    Mono<Void> rollback() {
        return Mono.fromDirect((Publisher)this.transaction.rollback()).then();
    }

    Mono<Void> close() {
        return Mono.fromDirect((Publisher)this.session.close()).then();
    }

    DatabaseSelection getDatabaseSelection() {
        return this.context.getDatabaseSelection();
    }

    UserSelection getUserSelection() {
        return this.context.getUserSelection();
    }

    Collection<Bookmark> getBookmarks() {
        return this.context.getBookmarks();
    }
}

