/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;

final class KPropertyFilterSupport {
    static Collection<String> getRequiredProperties(Class<?> type) {
        if (!KotlinDetector.isKotlinPresent() || !KotlinDetector.isKotlinType(type)) {
            return Collections.emptyList();
        }
        PreferredConstructor discover = PreferredConstructorDiscoverer.discover(type);
        if (discover == null) {
            return Collections.emptyList();
        }
        KFunction preferredConstructor = ReflectJvmMapping.getKotlinFunction((Constructor)discover.getConstructor());
        if (preferredConstructor == null) {
            return Collections.emptyList();
        }
        return preferredConstructor.getParameters().stream().filter(Predicate.not(KParameter::isOptional)).map(KParameter::getName).toList();
    }

    private KPropertyFilterSupport() {
    }
}

