/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.2")
final class FetchableFluentQueryByExample<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Neo4jMappingContext mappingContext;
    private final Example<S> example;
    private final FluentFindOperation findOperation;
    private final Function<Example<S>, Long> countOperation;
    private final Function<Example<S>, Boolean> existsOperation;

    FetchableFluentQueryByExample(Example<S> example, Class<R> resultType, Neo4jMappingContext mappingContext, FluentFindOperation findOperation, Function<Example<S>, Long> countOperation, Function<Example<S>, Boolean> existsOperation) {
        this(example, resultType, mappingContext, findOperation, countOperation, existsOperation, Sort.unsorted(), null);
    }

    FetchableFluentQueryByExample(Example<S> example, Class<R> resultType, Neo4jMappingContext mappingContext, FluentFindOperation findOperation, Function<Example<S>, Long> countOperation, Function<Example<S>, Boolean> existsOperation, Sort sort, @Nullable Collection<String> properties) {
        super(resultType, sort, properties);
        this.mappingContext = mappingContext;
        this.example = example;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.properties);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        return new FetchableFluentQueryByExample<S, NR>(this.example, resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.mergeProperties(properties));
    }

    public R oneValue() {
        return this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExample(this.mappingContext, this.example, this.sort, this.createIncludedFieldsPredicate())).oneValue();
    }

    public R firstValue() {
        List<R> all = this.all();
        return all.isEmpty() ? null : (R)all.get(0);
    }

    public List<R> all() {
        return this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExample(this.mappingContext, this.example, this.sort, this.createIncludedFieldsPredicate())).all();
    }

    public Page<R> page(Pageable pageable) {
        List page = this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExample(this.mappingContext, this.example, pageable, this.createIncludedFieldsPredicate())).all();
        LongSupplier totalCountSupplier = this::count;
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    public Stream<R> stream() {
        return this.all().stream();
    }

    public long count() {
        return this.countOperation.apply(this.example);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.example);
    }
}

