/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DefaultReactiveDatabaseSelectionProvider;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE, since="6.0")
@FunctionalInterface
public interface ReactiveDatabaseSelectionProvider {
    public Mono<DatabaseSelection> getDatabaseSelection();

    public static ReactiveDatabaseSelectionProvider createStaticDatabaseSelectionProvider(String databaseName) {
        Assert.notNull((Object)databaseName, (String)"The database name must not be null.");
        Assert.hasText((String)databaseName, (String)"The database name must not be empty.");
        return () -> Mono.just((Object)DatabaseSelection.byName(databaseName));
    }

    public static ReactiveDatabaseSelectionProvider getDefaultSelectionProvider() {
        return DefaultReactiveDatabaseSelectionProvider.INSTANCE;
    }
}

