/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.path;

import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.path.DefaultRelationshipBacked;

public class ConvertingEntityPath<S, E>
implements EntityPath<S, E> {
    private final Neo4jTemplate template;
    private final Path delegate;

    @Override
    public <T> T startEntity(Class<T> ... types) {
        return this.projectEntityToFirstParameterOrCreateFromStoredType(this.startNode(), types);
    }

    private <T> T projectEntityToFirstParameterOrCreateFromStoredType(Node node, Class<T> ... types) {
        if (node == null) {
            return null;
        }
        if (types == null || types.length == 0) {
            return this.template.createEntityFromStoredType(node, MappingPolicy.LOAD_POLICY);
        }
        return this.template.projectTo(node, types[0]);
    }

    @Override
    public <T> T endEntity(Class<T> ... types) {
        return this.projectEntityToFirstParameterOrCreateFromStoredType(this.endNode(), types);
    }

    @Override
    public <T> T lastRelationshipEntity(Class<T> ... types) {
        Relationship relationship = this.lastRelationship();
        if (relationship == null) {
            return null;
        }
        return this.template.projectTo(relationship, ConvertingEntityPath.getFirstOrDefault(DefaultRelationshipBacked.class, types));
    }

    private static <T> T getFirstOrDefault(T defaultValue, T ... values) {
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return values[0];
    }

    @Override
    public <T> Iterable<T> nodeEntities() {
        return new IterableWrapper<T, Node>(this.nodes()){

            protected T underlyingObjectToObject(Node node) {
                return ConvertingEntityPath.this.template.createEntityFromStoredType(node, null);
            }
        };
    }

    @Override
    public <T> Iterable<T> relationshipEntities(final Class<T> ... relationships) {
        return new IterableWrapper<T, Relationship>(this.relationships()){

            protected T underlyingObjectToObject(Relationship relationship) {
                return ConvertingEntityPath.this.template.projectTo(relationship, (Class)ConvertingEntityPath.getFirstOrDefault(DefaultRelationshipBacked.class, relationships));
            }
        };
    }

    @Override
    public <T> Iterable<T> allPathEntities(final Class<T> ... relationships) {
        return new IterableWrapper<T, PropertyContainer>((Iterable)this.delegate){

            protected T underlyingObjectToObject(PropertyContainer element) {
                return ConvertingEntityPath.this.template.projectTo(element, (Class)ConvertingEntityPath.getFirstOrDefault(DefaultRelationshipBacked.class, relationships));
            }
        };
    }

    public ConvertingEntityPath(Path delegate, Neo4jTemplate template) {
        this.delegate = delegate;
        this.template = template;
    }

    public Node startNode() {
        return this.delegate.startNode();
    }

    public Node endNode() {
        return this.delegate.endNode();
    }

    public Relationship lastRelationship() {
        return this.delegate.lastRelationship();
    }

    public Iterable<Relationship> relationships() {
        return this.delegate.relationships();
    }

    public Iterable<Relationship> reverseRelationships() {
        return this.delegate.reverseRelationships();
    }

    public Iterable<Node> reverseNodes() {
        return this.delegate.reverseNodes();
    }

    public Iterable<Node> nodes() {
        return this.delegate.nodes();
    }

    public int length() {
        return this.delegate.length();
    }

    public Iterator<PropertyContainer> iterator() {
        return this.delegate.iterator();
    }
}

