/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.index.lucene.ValueContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.mapping.InvalidEntityTypeException;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.mapping.EntityAlias;
import org.springframework.data.neo4j.support.mapping.EntityIndexCreator;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentPropertyImpl;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class Neo4jMappingContext
extends AbstractMappingContext<Neo4jPersistentEntityImpl<?>, Neo4jPersistentProperty> {
    private static final Logger log = LoggerFactory.getLogger(Neo4jMappingContext.class);
    private final Map<Annotation, Boolean> referenceAnnotations = new IdentityHashMap<Annotation, Boolean>();
    private EntityIndexCreator entityIndexCreator;
    private final Map<Class<?>, Class<?>> annotationCheckCache = new IdentityHashMap();
    private EntityAlias entityAlias = new EntityAlias();

    protected <T> Neo4jPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        Class type = typeInformation.getType();
        if (type.isAnnotationPresent(NodeEntity.class)) {
            return new Neo4jPersistentEntityImpl<T>(typeInformation, this.entityAlias);
        }
        if (type.isAnnotationPresent(RelationshipEntity.class)) {
            return new Neo4jPersistentEntityImpl<T>(typeInformation, this.entityAlias);
        }
        throw new InvalidEntityTypeException("Type " + type + " is neither a @NodeEntity nor a @RelationshipEntity");
    }

    protected Neo4jPersistentEntityImpl<?> addPersistentEntity(TypeInformation<?> typeInformation) {
        Neo4jPersistentEntityImpl entity = (Neo4jPersistentEntityImpl)super.addPersistentEntity(typeInformation);
        List<Neo4jPersistentEntity<?>> superTypeEntities = this.addSuperTypes(entity);
        this.updateStoredEntityType(entity, superTypeEntities);
        return entity;
    }

    private void updateStoredEntityType(Neo4jPersistentEntityImpl<?> entity, Collection<Neo4jPersistentEntity<?>> superTypeEntities) {
        entity.updateStoredType(superTypeEntities);
        if (this.entityIndexCreator != null) {
            this.entityIndexCreator.ensureEntityIndexes(entity);
        }
    }

    private List<Neo4jPersistentEntity<?>> addSuperTypes(Neo4jPersistentEntity<?> entity) {
        ArrayList entities = new ArrayList();
        LinkedHashSet typesToAdd = new LinkedHashSet();
        for (Class type = entity.getType(); type != null; type = type.getSuperclass()) {
            typesToAdd.add(type.getSuperclass());
            typesToAdd.addAll(Arrays.asList(type.getInterfaces()));
        }
        for (Class clazz : typesToAdd) {
            entities.addAll(this.addPersistentEntityWithCheck(clazz));
        }
        return entities;
    }

    private Collection<Neo4jPersistentEntity<?>> addPersistentEntityWithCheck(Class<?> type) {
        if (type != null && (this.isNodeEntityType(type) || this.isRelationshipEntityType(type))) {
            return Collections.singletonList(this.addPersistentEntity(type));
        }
        return Collections.emptyList();
    }

    public void initialize() {
        super.initialize();
        this.setStrict(true);
    }

    private boolean isRelationshipEntityType(Class<?> type) {
        return type.isAnnotationPresent(RelationshipEntity.class);
    }

    private boolean isNodeEntityType(Class<?> type) {
        return type.isAnnotationPresent(NodeEntity.class);
    }

    public Neo4jPersistentEntity<?> getPersistentEntity(Object alias) {
        for (Neo4jPersistentEntityImpl entity : this.getPersistentEntities()) {
            if (!entity.matchesAlias(alias)) continue;
            return entity;
        }
        return this.tryToResolveAliasAsEntityClassName(alias);
    }

    private Neo4jPersistentEntity<?> tryToResolveAliasAsEntityClassName(Object alias) {
        if (alias instanceof Class) {
            try {
                return (Neo4jPersistentEntity)this.getPersistentEntity((Class)alias);
            }
            catch (MappingException mappingException) {
                // empty catch block
            }
        }
        if (alias instanceof String && alias.toString().contains(".")) {
            try {
                return this.tryToResolveAliasAsEntityClassName(Class.forName(alias.toString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (alias instanceof StoredEntityType) {
            return ((StoredEntityType)alias).getEntity();
        }
        return null;
    }

    public StoredEntityType getStoredEntityType(Class type) {
        if (type == null) {
            return null;
        }
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.getPersistentEntity(type);
        return persistentEntity == null ? null : persistentEntity.getEntityType();
    }

    protected Neo4jPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, Neo4jPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new Neo4jPersistentPropertyImpl(field, descriptor, owner, simpleTypeHolder, this);
    }

    public boolean isNodeEntity(Class<?> type) {
        if (Node.class.isAssignableFrom(type)) {
            return true;
        }
        if (!this.annotationCheckCache.containsKey(type)) {
            this.cacheType(type);
        }
        return this.checkAnnotationType(type, NodeEntity.class);
    }

    private void cacheType(Class<?> type) {
        try {
            Neo4jPersistentEntityImpl entity = (Neo4jPersistentEntityImpl)this.getPersistentEntity(type);
            if (entity == null) {
                this.annotationCheckCache.put(type, type);
            } else if (!this.shouldCreatePersistentEntityFor((TypeInformation<?>)ClassTypeInformation.from(type))) {
                this.annotationCheckCache.put(type, type);
            } else if (entity.isNodeEntity()) {
                this.annotationCheckCache.put(type, NodeEntity.class);
            } else if (entity.isRelationshipEntity()) {
                this.annotationCheckCache.put(type, RelationshipEntity.class);
            } else {
                this.annotationCheckCache.put(type, type);
            }
        }
        catch (InvalidEntityTypeException me) {
            this.annotationCheckCache.put(type, type);
        }
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> typeInformation) {
        boolean result = super.shouldCreatePersistentEntityFor(typeInformation);
        if (!result) {
            return result;
        }
        if (typeInformation.isCollectionLike()) {
            return false;
        }
        Class type = typeInformation.getType();
        if (type.isEnum() || type.isArray() || type.equals(Node.class) || type.equals(Relationship.class) || type.equals(ValueContext.class)) {
            return false;
        }
        String packageName = type.getPackage().getName();
        return !packageName.startsWith("java");
    }

    private boolean checkAnnotationType(Class<?> type, Class<?> annotation) {
        Class<?> marker = this.annotationCheckCache.get(type);
        return marker == annotation;
    }

    public boolean isRelationshipEntity(Class<?> type) {
        if (!this.annotationCheckCache.containsKey(type)) {
            this.cacheType(type);
        }
        return this.checkAnnotationType(type, RelationshipEntity.class);
    }

    public void setPersistentState(Object entity, PropertyContainer pc) {
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.getPersistentEntity(entity.getClass());
        persistentEntity.setPersistentState(entity, pc);
    }

    public EntityAlias getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(EntityAlias entityAlias) {
        this.entityAlias = entityAlias;
    }

    public void setEntityIndexCreator(EntityIndexCreator entityIndexCreator) {
        this.entityIndexCreator = entityIndexCreator;
    }
}

