/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.PersistentEntityConversionException;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.EntityTools;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityFetchHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityPersister;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.mapping.SourceStateTransmitter;
import org.springframework.data.neo4j.support.typesafety.TypeSafetyOption;
import org.springframework.data.neo4j.support.typesafety.TypeSafetyPolicy;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class Neo4jEntityConverterImpl<T, S extends PropertyContainer>
implements Neo4jEntityConverter<T, S> {
    private final Neo4jMappingContext mappingContext;
    private final ConversionService conversionService;
    private final EntityInstantiator<S> entityInstantiator;
    private final EntityStateHandler entityStateHandler;
    private final TypeMapper<S> typeMapper;
    private final SourceStateTransmitter<S> sourceStateTransmitter;
    private final Neo4jEntityFetchHandler entityFetchHandler;

    public Neo4jEntityConverterImpl(Neo4jMappingContext mappingContext, ConversionService conversionService, EntityStateHandler entityStateHandler, Neo4jEntityFetchHandler entityFetchHandler, EntityTools<S> entityTools) {
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.entityStateHandler = entityStateHandler;
        this.entityFetchHandler = entityFetchHandler;
        this.entityInstantiator = new Neo4jEntityPersister.CachedInstantiator<S>(entityTools.getEntityInstantiator());
        this.typeMapper = entityTools.getTypeMapper();
        this.sourceStateTransmitter = entityTools.getSourceStateTransmitter();
    }

    @Override
    public MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public <R extends T> R read(Class<R> requestedType, S source, MappingPolicy mappingPolicy, Neo4jTemplate template) {
        TypeSafetyPolicy typeSafetyPolicy;
        ClassTypeInformation requestedTypeInformation = requestedType == null ? null : ClassTypeInformation.from(requestedType);
        TypeInformation targetType = this.typeMapper.readType(source, (TypeInformation)requestedTypeInformation);
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(targetType);
        if (mappingPolicy == null) {
            mappingPolicy = persistentEntity.getMappingPolicy();
        }
        if (!mappingPolicy.noTypeCheck() && (typeSafetyPolicy = template.getInfrastructure().getTypeSafetyPolicy()).isTypeSafetyEnabled() && !this.storedAndRequestedTypesMatch(requestedType, source)) {
            if (typeSafetyPolicy.getTypeSafetyOption() == TypeSafetyOption.RETURNS_NULL) {
                return null;
            }
            if (typeSafetyPolicy.getTypeSafetyOption() == TypeSafetyOption.THROWS_EXCEPTION) {
                Class sourceType = this.typeMapper.readType(source).getType();
                throw new PersistentEntityConversionException(requestedType, sourceType);
            }
        }
        Object createdEntity = this.entityInstantiator.createEntityFromState(source, targetType.getType(), mappingPolicy);
        this.entityStateHandler.setPersistentState(createdEntity, source);
        if (persistentEntity.isManaged()) {
            return (R)createdEntity;
        }
        this.loadEntity(createdEntity, source, mappingPolicy, persistentEntity, template);
        return (R)createdEntity;
    }

    @Override
    public <R extends T> R loadEntity(R entity, S source, MappingPolicy mappingPolicy, Neo4jPersistentEntityImpl<R> persistentEntity, Neo4jTemplate template) {
        if (mappingPolicy.shouldLoad()) {
            PersistentPropertyAccessor wrapper = persistentEntity.getPropertyAccessor(entity, this.conversionService);
            this.sourceStateTransmitter.copyPropertiesFrom(wrapper, source, persistentEntity, mappingPolicy, template);
            this.cascadeFetch(persistentEntity, wrapper, mappingPolicy, template);
        }
        return entity;
    }

    private <R extends T> boolean storedAndRequestedTypesMatch(Class<R> requestedType, S source) {
        if (requestedType == null) {
            return true;
        }
        TypeInformation storedType = this.typeMapper.readType(source);
        return requestedType.isAssignableFrom(storedType.getType());
    }

    private <R extends T> void cascadeFetch(Neo4jPersistentEntityImpl<R> persistentEntity, final PersistentPropertyAccessor wrapper, MappingPolicy policy, final Neo4jTemplate template) {
        persistentEntity.doWithAssociations((AssociationHandler)new AssociationHandler<Neo4jPersistentProperty>(){

            public void doWithAssociation(Association<Neo4jPersistentProperty> association) {
                Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
                MappingPolicy mappingPolicy = property.getMappingPolicy();
                if (mappingPolicy.shouldLoad() && property.isRelationship()) {
                    Object value = Neo4jEntityConverterImpl.this.getProperty(wrapper, property);
                    Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)Neo4jEntityConverterImpl.this.mappingContext.getPersistentEntity(property.getTypeInformation().getActualType());
                    Object fetchedValue = Neo4jEntityConverterImpl.this.entityFetchHandler.fetch(value, persistentEntity, property, mappingPolicy, template);
                    Neo4jEntityConverterImpl.this.sourceStateTransmitter.setProperty(wrapper, property, fetchedValue);
                }
            }
        });
    }

    private <R> Object getProperty(PersistentPropertyAccessor wrapper, Neo4jPersistentProperty property) {
        try {
            return wrapper.getProperty((PersistentProperty)property);
        }
        catch (Exception e) {
            throw new MappingException("Error retrieving property " + property.getName() + " from " + wrapper.getBean(), (Throwable)e);
        }
    }

    @Override
    public void write(T source, S target, MappingPolicy mappingPolicy, Neo4jTemplate template, RelationshipType annotationProvidedRelationshipType) {
        Class<?> sourceType = source.getClass();
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(sourceType);
        if (persistentEntity.isManaged()) {
            ((ManagedEntity)source).persist();
            return;
        }
        PersistentPropertyAccessor wrapper = persistentEntity.getPropertyAccessor(source, this.conversionService);
        if (target == null) {
            target = this.entityStateHandler.useOrCreateState(source, target, annotationProvidedRelationshipType);
            this.entityStateHandler.setPersistentState(source, target);
            this.typeMapper.writeType(sourceType, target);
        }
        this.sourceStateTransmitter.copyPropertiesTo(wrapper, target, persistentEntity, mappingPolicy, template);
    }
}

