/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityPersister;

public class EntityCreatingClosableIterable<T>
extends IterableWrapper<T, PropertyContainer>
implements ClosableIterable<T> {
    private final ClosableIterable<PropertyContainer> iterable;
    private final Class<T> entityClass;
    private final Neo4jEntityPersister entityPersister;
    private final MappingPolicy mappingPolicy;
    private final Neo4jTemplate template;

    public EntityCreatingClosableIterable(ClosableIterable<PropertyContainer> iterable, Class<T> entityClass, Neo4jEntityPersister entityPersister, Neo4jTemplate template) {
        super(iterable);
        this.iterable = iterable;
        this.entityClass = entityClass;
        this.entityPersister = entityPersister;
        this.template = template;
        this.mappingPolicy = this.entityPersister.getMappingPolicy(this.entityClass);
    }

    protected T underlyingObjectToObject(PropertyContainer state) {
        return this.entityPersister.createEntityFromState(state, this.entityClass, this.mappingPolicy, this.template);
    }

    public void close() {
        this.iterable.close();
    }
}

