/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.Traversal;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.Neo4jEmbeddedTransactionManager;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.query.CypherQueryEngineImpl;
import org.springframework.data.neo4j.support.schema.SchemaIndexProvider;
import org.springframework.util.ObjectUtils;

public class DelegatingGraphDatabase
implements GraphDatabase {
    private static final Logger log = LoggerFactory.getLogger(DelegatingGraphDatabase.class);
    private static final Label[] NO_LABELS = new Label[0];
    private SchemaIndexProvider schemaIndexProvider;
    protected GraphDatabaseService delegate;
    private ConversionService conversionService;
    private ResultConverter resultConverter;
    private volatile CypherQueryEngineImpl cypherQueryEngine;
    static Constructor springTxManagerConstructor;

    public DelegatingGraphDatabase(GraphDatabaseService delegate) {
        this(delegate, null);
    }

    public DelegatingGraphDatabase(GraphDatabaseService delegate, ResultConverter resultConverter) {
        this.delegate = delegate;
        this.resultConverter = resultConverter;
        this.schemaIndexProvider = new SchemaIndexProvider(this);
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public void setResultConverter(ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
        if (this.cypherQueryEngine != null) {
            this.cypherQueryEngine.setResultConverter(this.resultConverter);
        }
    }

    @Override
    public Node getNodeById(long id) {
        return this.delegate.getNodeById(id);
    }

    @Override
    public Node createNode(Map<String, Object> props, Collection<String> labels) {
        return this.setProperties(this.delegate.createNode(this.toLabels(labels)), props);
    }

    private Label[] toLabels(Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return NO_LABELS;
        }
        Label[] labelArray = new Label[labels.size()];
        int i = 0;
        for (String label : labels) {
            labelArray[i++] = DynamicLabel.label((String)label);
        }
        return labelArray;
    }

    private <T extends PropertyContainer> T setProperties(T primitive, Map<String, Object> properties) {
        assert (primitive != null);
        if (properties == null || properties.isEmpty()) {
            return primitive;
        }
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            if (prop.getValue() == null) {
                primitive.removeProperty(prop.getKey());
                continue;
            }
            primitive.setProperty(prop.getKey(), prop.getValue());
        }
        return primitive;
    }

    private void removeFromIndexes(Node node) {
        IndexManager indexManager = this.delegate.index();
        for (String indexName : indexManager.nodeIndexNames()) {
            Index nodeIndex = indexManager.forNodes(indexName);
            if (!nodeIndex.isWriteable()) continue;
            nodeIndex.remove((PropertyContainer)node);
        }
    }

    private void removeFromIndexes(Relationship relationship) {
        IndexManager indexManager = this.delegate.index();
        for (String indexName : indexManager.relationshipIndexNames()) {
            RelationshipIndex relationshipIndex = indexManager.forRelationships(indexName);
            if (!relationshipIndex.isWriteable()) continue;
            relationshipIndex.remove((PropertyContainer)relationship);
        }
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.delegate.getRelationshipById(id);
    }

    @Override
    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> properties) {
        return this.setProperties(startNode.createRelationshipTo(endNode, type), properties);
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        IndexManager indexManager = this.delegate.index();
        if (indexManager.existsForNodes(indexName)) {
            return indexManager.forNodes(indexName);
        }
        if (indexManager.existsForRelationships(indexName)) {
            return indexManager.forRelationships(indexName);
        }
        throw new NoSuchIndexException(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, IndexType indexType) {
        Transaction tx = this.delegate.beginTx();
        try {
            IndexManager indexManager = this.delegate.index();
            if (this.isNode(type)) {
                Index index;
                if (indexManager.existsForNodes(indexName)) {
                    Index<T> index2 = this.checkAndGetExistingIndex(indexName, indexType, indexManager.forNodes(indexName));
                    return index2;
                }
                Index index3 = index = indexManager.forNodes(indexName, this.indexConfigFor(indexType));
                return index3;
            }
            if (indexManager.existsForRelationships(indexName)) {
                Index<T> index = this.checkAndGetExistingIndex(indexName, indexType, (Index<T>)indexManager.forRelationships(indexName));
                return index;
            }
            RelationshipIndex relationshipIndex = indexManager.forRelationships(indexName, this.indexConfigFor(indexType));
            return relationshipIndex;
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    private <T extends PropertyContainer> Index<T> checkAndGetExistingIndex(String indexName, IndexType indexType, Index<T> index) {
        Map existingConfig = this.delegate.index().getConfiguration(index);
        Map<String, String> config = this.indexConfigFor(indexType);
        if (this.configCheck(config, existingConfig, "provider") && this.configCheck(config, existingConfig, "type")) {
            return index;
        }
        throw new IllegalArgumentException("Setup for index " + indexName + " does not match. Existing: " + existingConfig + " required " + config);
    }

    private boolean configCheck(Map<String, String> config, Map<String, String> existingConfig, String setting) {
        return ObjectUtils.nullSafeEquals((Object)config.get(setting), (Object)existingConfig.get(setting));
    }

    private Map<String, String> indexConfigFor(IndexType indexType) {
        return indexType.getConfig();
    }

    @Override
    public TraversalDescription traversalDescription() {
        return Traversal.description();
    }

    @Override
    public CypherQueryEngine queryEngine() {
        return this.queryEngine(this.createResultConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CypherQueryEngineImpl queryEngine(ResultConverter resultConverter, boolean reinit) {
        if (reinit || this.cypherQueryEngine == null) {
            DelegatingGraphDatabase delegatingGraphDatabase = this;
            synchronized (delegatingGraphDatabase) {
                if (reinit || this.cypherQueryEngine == null) {
                    this.cypherQueryEngine = this.createCypherQueryEngine(resultConverter);
                }
            }
        }
        return this.cypherQueryEngine;
    }

    @Override
    public CypherQueryEngineImpl queryEngine(ResultConverter resultConverter) {
        return this.queryEngine(resultConverter, false);
    }

    private CypherQueryEngineImpl createCypherQueryEngine(ResultConverter resultConverter) {
        return new CypherQueryEngineImpl(this.delegate, resultConverter);
    }

    @Override
    public boolean transactionIsRunning() {
        if (!(this.delegate instanceof GraphDatabaseAPI)) {
            return true;
        }
        try {
            TransactionManager txManager = (TransactionManager)((GraphDatabaseAPI)this.delegate).getDependencyResolver().resolveDependency(TransactionManager.class);
            return txManager.getStatus() != 6;
        }
        catch (SystemException e) {
            log.error("Error accessing TransactionManager", (Throwable)e);
            return false;
        }
    }

    @Override
    public TransactionManager getTransactionManager() {
        if (springTxManagerConstructor == null) {
            return new Neo4jEmbeddedTransactionManager(this.delegate);
        }
        try {
            return (TransactionManager)springTxManagerConstructor.newInstance((GraphDatabaseAPI)this.delegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Transaction beginTx() {
        return this.delegate.beginTx();
    }

    @Override
    public void remove(Node node) {
        this.removeFromIndexes(node);
        node.delete();
    }

    @Override
    public void remove(Relationship relationship) {
        this.removeFromIndexes(relationship);
        relationship.delete();
    }

    private ResultConverter createResultConverter() {
        if (this.resultConverter != null) {
            return this.resultConverter;
        }
        this.resultConverter = this.conversionService != null ? new ConversionServiceQueryResultConverter(this.conversionService) : new DefaultConverter();
        return this.resultConverter;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public Collection<String> getAllLabelNames() {
        HashSet<String> labels = new HashSet<String>();
        for (Label label : GlobalGraphOperations.at((GraphDatabaseService)this.delegate).getAllLabels()) {
            labels.add(label.name());
        }
        return labels;
    }

    @Override
    public Relationship getOrCreateRelationship(Node start, Node end, RelationshipType type, Direction direction, Map<String, Object> props) {
        Iterable existingRelationships = start.getRelationships(type, direction);
        for (Relationship existingRelationship : existingRelationships) {
            if (existingRelationship == null || !existingRelationship.getOtherNode(start).equals(end)) continue;
            return existingRelationship;
        }
        Relationship rel = direction == Direction.INCOMING ? end.createRelationshipTo(start, type) : start.createRelationshipTo(end, type);
        this.setProperties(rel, props);
        return rel;
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.delegate;
    }

    @Override
    public Node merge(String labelName, String key, Object value, Map<String, Object> nodeProperties, Collection<String> labels) {
        return this.schemaIndexProvider.merge(labelName, key, value, nodeProperties, labels);
    }

    @Override
    public Node getOrCreateNode(String indexName, String key, Object value, final Map<String, Object> nodeProperties, final Collection<String> labels) {
        if (indexName == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + indexName + " key " + key + " value must not be null");
        }
        if (value instanceof Number) {
            value = ValueContext.numeric((Number)((Number)value));
        }
        UniqueFactory.UniqueNodeFactory factory = new UniqueFactory.UniqueNodeFactory(this.delegate, indexName){

            protected void initialize(Node node, Map<String, Object> _) {
                DelegatingGraphDatabase.this.setProperties((PropertyContainer)node, nodeProperties);
                DelegatingGraphDatabase.this.setLabels(node, labels);
            }
        };
        return (Node)factory.getOrCreate(key, value);
    }

    private Node setLabels(Node node, Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return node;
        }
        for (String label : labels) {
            node.addLabel(DynamicLabel.label((String)label));
        }
        return node;
    }

    @Override
    public Relationship getOrCreateRelationship(String indexName, String key, Object value, final Node startNode, final Node endNode, final String type, final Map<String, Object> properties) {
        if (indexName == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + indexName + " key " + key + " value must not be null");
        }
        if (startNode == null || endNode == null || type == null) {
            throw new IllegalArgumentException("StartNode " + startNode + " EndNode " + endNode + " and type " + type + " must not be null");
        }
        if (value instanceof Number) {
            value = ValueContext.numeric((Number)((Number)value));
        }
        UniqueFactory.UniqueRelationshipFactory factory = new UniqueFactory.UniqueRelationshipFactory(this.delegate, indexName){

            protected Relationship create(Map<String, Object> _) {
                Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
                return (Relationship)DelegatingGraphDatabase.this.setProperties((PropertyContainer)relationship, properties);
            }
        };
        return (Relationship)factory.getOrCreate(key, value);
    }

    static {
        try {
            springTxManagerConstructor = Class.forName("org.neo4j.kernel.impl.transaction.SpringTransactionManager").getConstructor(GraphDatabaseAPI.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            springTxManagerConstructor = null;
        }
    }
}

