/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Arrays;
import java.util.Date;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.data.neo4j.repository.GeoConverter;

public class Neo4jConversionServiceFactoryBean
implements FactoryBean<ConversionService> {
    public ConversionService getObject() throws Exception {
        GenericConversionService conversionService = new GenericConversionService();
        this.addConverters((ConversionService)conversionService);
        DefaultConversionService.addDefaultConverters((ConverterRegistry)conversionService);
        return conversionService;
    }

    public void addConverters(ConversionService service) {
        if (!(service instanceof ConverterRegistry)) {
            throw new IllegalArgumentException("conversionservice is no ConverterRegistry:" + service);
        }
        ConverterRegistry registry = (ConverterRegistry)service;
        registry.addConverter((Converter)new DateToStringConverter());
        registry.addConverter((Converter)new DateToLongConverter());
        registry.addConverter((Converter)new StringToDateConverter());
        registry.addConverter((Converter)new NumberToDateConverter());
        registry.addConverter((Converter)new EnumToStringConverter());
        registry.addConverter((Converter)new EnumToIntegerConverter());
        registry.addConverter((Converter)new ShapeToStringConverter());
        registry.addConverter((Converter)new StringToShapeConverter());
        registry.addConverter((Converter)new PointToStringConverter());
        registry.addConverter((Converter)new StringToPointConverter());
        registry.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
        registry.addConverterFactory((ConverterFactory)new NumberToEnumConverterFactory());
    }

    public Class<?> getObjectType() {
        return GenericConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static class NumberToEnumConverterFactory
    implements ConverterFactory<Number, Enum> {
        public <T extends Enum> Converter<Number, T> getConverter(Class<T> targetType) {
            return new NumberToEnum<T>(targetType);
        }

        private static class NumberToEnum<T extends Enum>
        implements Converter<Number, T> {
            private final Class<T> enumType;

            public NumberToEnum(Class<T> enumType) {
                this.enumType = enumType;
            }

            public T convert(Number source) {
                if (source == null) {
                    return null;
                }
                Object[] values = (Enum[])this.enumType.getEnumConstants();
                int ordinal = source.intValue();
                if (ordinal < 0 || ordinal >= values.length) {
                    throw new IllegalArgumentException("Ordinal value for Enum out of range " + ordinal + " " + Arrays.toString(values));
                }
                return (T)values[ordinal];
            }
        }
    }

    public static class StringToEnumConverterFactory
    implements ConverterFactory<String, Enum> {
        public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
            return new StringToEnum<T>(targetType);
        }

        private static class StringToEnum<T extends Enum>
        implements Converter<String, T> {
            private final Class<T> enumType;

            public StringToEnum(Class<T> enumType) {
                this.enumType = enumType;
            }

            public T convert(String source) {
                if (source == null) {
                    return null;
                }
                String trimmed = source.trim();
                if (trimmed.isEmpty()) {
                    return null;
                }
                return Enum.valueOf(this.enumType, trimmed);
            }
        }
    }

    public static class StringToPointConverter
    implements Converter<String, Point> {
        public Point convert(String source) {
            return GeoConverter.pointFromWellKnownText(source);
        }
    }

    public static class StringToShapeConverter
    implements Converter<String, Shape> {
        public Shape convert(String source) {
            return GeoConverter.fromWellKnownText(source);
        }
    }

    public static class PointToStringConverter
    implements Converter<Point, String> {
        public String convert(Point source) {
            return GeoConverter.toWellKnownText(source);
        }
    }

    public static class ShapeToStringConverter
    implements Converter<Shape, String> {
        public String convert(Shape source) {
            return GeoConverter.toWellKnownText(source);
        }
    }

    public static class EnumToIntegerConverter
    implements Converter<Enum, Integer> {
        public Integer convert(Enum source) {
            return source.ordinal();
        }
    }

    public static class EnumToStringConverter
    implements Converter<Enum, String> {
        public String convert(Enum source) {
            return source.name();
        }
    }

    public static class StringToDateConverter
    implements Converter<String, Date> {
        public Date convert(String source) {
            return new Date(Long.valueOf(source));
        }
    }

    public static class NumberToDateConverter
    implements Converter<Number, Date> {
        public Date convert(Number source) {
            return new Date(source.longValue());
        }
    }

    public static class DateToLongConverter
    implements Converter<Date, Long> {
        public Long convert(Date source) {
            return source.getTime();
        }
    }

    public static class DateToStringConverter
    implements Converter<Date, String> {
        public String convert(Date source) {
            return String.valueOf(source.getTime());
        }
    }
}

