/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonHelper {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Map<String, Object> jsonToMap(String json) {
        return (Map)JsonHelper.readJson(json);
    }

    public static List<Map<String, Object>> jsonToListOfRelationshipRepresentations(String json) {
        return (List)JsonHelper.readJson(json);
    }

    public static Object readJson(String json) {
        try {
            return OBJECT_MAPPER.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading as JSON '" + json + "'", e);
        }
    }

    public static Object jsonToSingleValue(String json) {
        Object jsonObject = JsonHelper.readJson(json);
        return jsonObject;
    }

    public static String createJsonFrom(Object data) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = OBJECT_MAPPER.getJsonFactory().createJsonGenerator((Writer)writer).useDefaultPrettyPrinter();
            OBJECT_MAPPER.writeValue(generator, data);
            writer.close();
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream stream) {
        try {
            String string = new Scanner(stream).useDelimiter("\\Z").next();
            return string;
        }
        catch (Exception ioe) {
            System.err.println("Error reading string from stream " + ioe.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

