/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.rest.graphdb.query.CypherTransaction;
import org.neo4j.rest.graphdb.transaction.TransactionFinishListener;

public class RemoteCypherTransaction
implements Transaction {
    private final List<TransactionFinishListener> listeners = new ArrayList<TransactionFinishListener>();
    int status = 6;
    boolean success;
    boolean failure;
    CypherTransaction tx;
    AtomicInteger innerCounter = new AtomicInteger(1);

    public String toString() {
        return "RemoteCypherTransaction@" + System.identityHashCode(this) + "{status=" + this.status + ", success=" + this.success + ", failure=" + this.failure + ", tx=" + this.tx + ", innerCounter=" + this.innerCounter + '}';
    }

    public void registerListener(TransactionFinishListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public RemoteCypherTransaction(CypherTransaction tx) {
        this.tx = tx;
        this.status = 0;
    }

    public void beginInner() {
        if (this.status != 0 && this.status != 8 && this.status != 1) {
            throw new IllegalStateException("Can't begin nested tx on non-active transaction status is " + this.status + " tx " + this);
        }
        this.innerCounter.incrementAndGet();
    }

    public void success() {
        this.success = true;
        if (!this.failure) {
            this.status = 8;
        }
    }

    public void finish() {
        this.close();
    }

    public void close() {
        if (this.tx() != null && this.innerCounter.decrementAndGet() > 0) {
            return;
        }
        try {
            if (this.success && !this.failure) {
                this.tx().commit();
                this.status = 3;
            } else {
                if (this.tx() != null) {
                    this.tx().rollback();
                }
                this.status = 4;
            }
        }
        finally {
            this.tx = null;
            this.notifyFinish();
        }
    }

    private void notifyFinish() {
        for (TransactionFinishListener listener : this.listeners) {
            if (this.status == 3) {
                listener.comitted();
                continue;
            }
            listener.rolledBack();
        }
        this.listeners.clear();
    }

    private CypherTransaction tx() {
        if (this.tx == null && !this.failure) {
            throw new IllegalStateException("No transaction active");
        }
        return this.tx;
    }

    public void failure() {
        this.failure = true;
        this.status = 1;
    }

    public Lock acquireWriteLock(PropertyContainer pc) {
        if (pc instanceof Node) {
            this.tx().send("MATCH (n) WHERE id(n) = {id} REMOVE n.` lock property `", MapUtil.map((Object[])new Object[]{"id", ((Node)pc).getId()}), false);
        }
        if (pc instanceof Relationship) {
            this.tx().send("START r=rel({id}) REMOVE r.` lock property `", MapUtil.map((Object[])new Object[]{"id", ((Relationship)pc).getId()}), false);
        }
        return new Lock(){

            public void release() {
            }
        };
    }

    public Lock acquireReadLock(PropertyContainer propertyContainer) {
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public CypherTransaction getTransaction() {
        return this.tx;
    }

    public boolean isActive() {
        return this.tx != null;
    }

    public void terminate() {
        this.failure();
        this.close();
    }
}

