/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.converter;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.converter.RestResultConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;

public class RestEntityExtractor
implements RestResultConverter {
    private final RestAPI restApi;

    public RestEntityExtractor(RestAPI restApi) {
        this.restApi = restApi;
    }

    @Override
    public Object convertFromRepresentation(RequestResult requestResult) {
        return this.convertFromRepresentation(requestResult.toEntity());
    }

    public Object convertFromRepresentation(Object value) {
        if (value instanceof PropertyContainer) {
            return value;
        }
        if (value instanceof Map) {
            if (this.canHandle(value)) {
                value = this.convertToEntityIfPossible(value);
            } else {
                Map source = (Map)value;
                HashMap result = new HashMap(source.size());
                for (Map.Entry entry : source.entrySet()) {
                    result.put(entry.getKey(), this.convertFromRepresentation(entry.getValue()));
                }
                return result;
            }
        }
        if (value instanceof Iterable) {
            AbstractCollection result = value instanceof Set ? new HashSet() : new ArrayList();
            for (Object o : (Iterable)value) {
                result.add(this.convertFromRepresentation(o));
            }
            return result;
        }
        return value;
    }

    private Object convertToEntityIfPossible(Object value) {
        RestEntity restEntity;
        if (value instanceof Map && (restEntity = this.restApi.createRestEntity((Map)value)) != null) {
            return restEntity;
        }
        return value;
    }

    public boolean canHandle(Object value) {
        String uri;
        return value instanceof Map && (uri = (String)((Map)value).get("self")) != null && (uri.contains("/node/") || uri.contains("/relationship/"));
    }
}

