/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.batch;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.rest.graphdb.batch.RestOperations;

public class RecordingRestRequest {
    private final String baseUri;
    private MediaType contentType;
    private MediaType acceptHeader;
    private RestOperations operations;
    private boolean stop;

    public RestOperations getOperations() {
        return this.operations;
    }

    public RecordingRestRequest(String baseUri) {
        this(baseUri, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
    }

    public RecordingRestRequest(RestOperations operations, String baseUri) {
        this(baseUri);
        this.operations = operations;
    }

    public RecordingRestRequest(String baseUri, MediaType contentType, MediaType acceptHeader) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        this.contentType = contentType;
        this.acceptHeader = acceptHeader;
    }

    public RestOperations.RestOperation get(String path, Object data) {
        return this.record(RestOperations.RestOperation.Methods.GET, path, data, this.getBaseUri());
    }

    public RestOperations.RestOperation delete(String path) {
        return this.record(RestOperations.RestOperation.Methods.DELETE, path, null, this.getBaseUri());
    }

    public RestOperations.RestOperation post(String path, Object data) {
        return this.record(RestOperations.RestOperation.Methods.POST, path, data, this.getBaseUri());
    }

    public RestOperations.RestOperation put(String path, Object data) {
        return this.record(RestOperations.RestOperation.Methods.PUT, path, data, this.getBaseUri());
    }

    public RecordingRestRequest with(String uri) {
        return new RecordingRestRequest(this.operations, uri);
    }

    public String getUri() {
        return this.getBaseUri();
    }

    public RestOperations.RestOperation get(String path) {
        return this.record(RestOperations.RestOperation.Methods.GET, path, null, this.getBaseUri());
    }

    public RestOperations.RestOperation record(RestOperations.RestOperation.Methods method, String path, Object data, String baseUri) {
        if (this.stop) {
            throw new IllegalStateException("BatchRequest already executed");
        }
        return this.operations.record(method, path, data, baseUri);
    }

    private String uriWithoutSlash(String uri) {
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    public static String encode(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.toString(), "utf-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Long, RestOperations.RestOperation> getRecordedRequests() {
        return this.operations.getRecordedRequests();
    }

    public void stop() {
        this.stop = true;
    }

    public String getBaseUri() {
        return this.baseUri;
    }
}

