/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.UserAgent;
import org.neo4j.rest.graphdb.util.Config;
import org.neo4j.rest.graphdb.util.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutingRestRequest
implements RestRequest {
    private static final Logger log = LoggerFactory.getLogger(RestRequest.class);
    public static final MediaType STREAMING_JSON_TYPE = new MediaType(MediaType.APPLICATION_JSON_TYPE.getType(), MediaType.APPLICATION_JSON_TYPE.getSubtype(), MapUtil.stringMap((String[])new String[]{"stream", "true"}));
    private final String baseUri;
    private final UserAgent userAgent = new UserAgent();
    private final Client client;
    private static boolean sslHandshakeEnabled = true;

    public ExecutingRestRequest(String baseUri) {
        this(baseUri, null, null);
    }

    public ExecutingRestRequest(String baseUri, String username, String password) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        this.client = this.createClient();
        this.addAuthFilter(username, password);
    }

    protected void addAuthFilter(String username, String password) {
        if (username == null) {
            return;
        }
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
    }

    protected Client createClient() {
        if (Config.ignoreSSLHandshake() && sslHandshakeEnabled) {
            ExecutingRestRequest.disableCertificateValidation();
        }
        Client client = Client.create();
        client.setConnectTimeout(Integer.valueOf(Config.getConnectTimeout()));
        client.setReadTimeout(Integer.valueOf(Config.getReadTimeout()));
        client.setChunkedEncodingSize(Integer.valueOf(8192));
        this.userAgent.install(client);
        if (Config.useLoggingFilter()) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        return client;
    }

    private ExecutingRestRequest(String uri, Client client) {
        this.baseUri = this.uriWithoutSlash(uri);
        this.client = client;
    }

    protected String uriWithoutSlash(String uri) {
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    public static String encode(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.toString(), "utf-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private WebResource.Builder builder(String path) {
        WebResource resource = this.client.resource(this.uri(this.pathOrAbsolute(path)));
        if (Config.streamingIsEnabled()) {
            return (WebResource.Builder)resource.accept(new MediaType[]{STREAMING_JSON_TYPE}).header("X-Stream", (Object)"true");
        }
        return resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    private String pathOrAbsolute(String path) {
        if (path.contains("://")) {
            return path;
        }
        return this.baseUri + "/" + path;
    }

    @Override
    public RequestResult get(String path) {
        if (log.isDebugEnabled()) {
            log.debug("GET " + path);
        }
        return RequestResult.extractFrom((ClientResponse)this.builder(path).get(ClientResponse.class));
    }

    @Override
    public RequestResult get(String path, Object data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)JsonHelper.createJsonFrom(data), MediaType.APPLICATION_JSON_TYPE);
        }
        if (log.isDebugEnabled()) {
            log.debug("GET " + path + " " + data);
        }
        return RequestResult.extractFrom((ClientResponse)builder.get(ClientResponse.class));
    }

    @Override
    public RequestResult delete(String path) {
        if (log.isDebugEnabled()) {
            log.debug("DELETE " + path);
        }
        return RequestResult.extractFrom((ClientResponse)this.builder(path).delete(ClientResponse.class));
    }

    @Override
    public RequestResult post(String path, Object data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            Object payload = data instanceof InputStream ? data : JsonHelper.createJsonFrom(data);
            builder = (WebResource.Builder)builder.entity(payload, MediaType.APPLICATION_JSON_TYPE);
        }
        if (log.isDebugEnabled()) {
            log.debug("POST " + path + " " + data);
        }
        return RequestResult.extractFrom((ClientResponse)builder.post(ClientResponse.class));
    }

    @Override
    public RequestResult put(String path, Object data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)JsonHelper.createJsonFrom(data), MediaType.APPLICATION_JSON_TYPE);
        }
        if (log.isDebugEnabled()) {
            log.debug("PUT " + path + " " + data);
        }
        return RequestResult.extractFrom((ClientResponse)builder.put(ClientResponse.class));
    }

    @Override
    public RestRequest with(String uri) {
        return new ExecutingRestRequest(uri, this.client);
    }

    private URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sslHandshakeEnabled = false;
        log.warn("Certificate validation has been disabled");
    }

    @Override
    public String getUri() {
        return this.baseUri;
    }

    @Override
    public Map<?, ?> toMap(RequestResult requestResult) {
        return requestResult.toMap();
    }

    public static void shutdown() {
    }
}

