/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.AggregationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.ReflectionUtils;

public class StringBasedAggregation
extends AbstractMongoQuery {
    private final MongoOperations mongoOperations;
    private final MongoConverter mongoConverter;

    public StringBasedAggregation(MongoQueryMethod method, MongoOperations mongoOperations, ValueExpressionDelegate delegate) {
        super(method, mongoOperations, delegate);
        if (method.isPageQuery()) {
            throw new InvalidMongoDbApiUsageException(String.format("Repository aggregation method '%s' does not support '%s' return type; Please use 'Slice' or 'List' instead", method.getName(), method.getReturnType().getType().getSimpleName()));
        }
        this.mongoOperations = mongoOperations;
        this.mongoConverter = mongoOperations.getConverter();
    }

    @Override
    protected @Nullable Object doExecute(MongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> ignore) {
        return AggregationUtils.doAggregate(AggregationUtils.computePipeline(this, method, accessor), method, processor, accessor, this::getExpressionEvaluatorFor, (aggregation, sourceType, typeToRead, elementType, simpleType, rawResult) -> {
            if (method.isStreamQuery()) {
                Stream stream = this.mongoOperations.aggregateStream(aggregation, typeToRead);
                if (!simpleType || elementType.equals(Document.class)) {
                    return stream;
                }
                return stream.map(it -> AggregationUtils.extractSimpleTypeResult((Document)it, elementType, this.mongoConverter));
            }
            AggregationResults result = this.mongoOperations.aggregate(aggregation, typeToRead);
            if (ReflectionUtils.isVoid((Class)elementType)) {
                return null;
            }
            if (rawResult) {
                return result;
            }
            List<Document> results = result.getMappedResults();
            if (method.isCollectionQuery()) {
                return simpleType ? this.convertResults(elementType, results) : results;
            }
            if (method.isSliceQuery()) {
                Pageable pageable = accessor.getPageable();
                int pageSize = pageable.getPageSize();
                List<Document> resultsToUse = simpleType ? this.convertResults(elementType, results) : results;
                boolean hasNext = resultsToUse.size() > pageSize;
                return new SliceImpl(hasNext ? resultsToUse.subList(0, pageSize) : resultsToUse, pageable, hasNext);
            }
            Object uniqueResult = result.getUniqueMappedResult();
            return simpleType ? AggregationUtils.extractSimpleTypeResult((Document)uniqueResult, elementType, this.mongoConverter) : uniqueResult;
        });
    }

    private List<Object> convertResults(Class<?> targetType, List<Document> mappedResults) {
        ArrayList<Object> list = new ArrayList<Object>(mappedResults.size());
        for (Document it : mappedResults) {
            Object extractSimpleTypeResult = AggregationUtils.extractSimpleTypeResult(it, targetType, this.mongoConverter);
            list.add(extractSimpleTypeResult);
        }
        return list;
    }

    private boolean isSimpleReturnType(Class<?> targetType) {
        return MongoSimpleTypes.HOLDER.isSimpleType(targetType);
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("No query support for aggregation");
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

