/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.repository.aot.MongoInteraction;
import org.springframework.data.mongodb.repository.aot.QueryInteraction;
import org.springframework.data.mongodb.repository.aot.StringUpdate;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.util.Assert;

class UpdateInteraction
extends MongoInteraction
implements QueryMetadata {
    private final QueryInteraction filter;
    private final @Nullable StringUpdate update;
    private final @Nullable Integer updateDefinitionParameter;

    UpdateInteraction(QueryInteraction filter, @Nullable StringUpdate update, @Nullable Integer updateDefinitionParameter) {
        this.filter = filter;
        this.update = update;
        this.updateDefinitionParameter = updateDefinitionParameter;
    }

    public QueryInteraction getFilter() {
        return this.filter;
    }

    public @Nullable StringUpdate getUpdate() {
        return this.update;
    }

    public int getRequiredUpdateDefinitionParameter() {
        Assert.notNull((Object)this.updateDefinitionParameter, (String)"UpdateDefinitionParameter must not be null!");
        return this.updateDefinitionParameter;
    }

    public boolean hasUpdateDefinitionParameter() {
        return this.updateDefinitionParameter != null;
    }

    public Map<String, Object> serialize() {
        Map<String, Object> serialized = this.filter.serialize();
        if (this.update != null) {
            serialized.put("filter", this.filter.getQuery().getQueryString());
            serialized.put("update", this.update.getUpdateString());
        }
        return serialized;
    }

    @Override
    MongoInteraction.InteractionType getExecutionType() {
        return MongoInteraction.InteractionType.UPDATE;
    }
}

