/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.mongodb.repository.aot.MongoInteraction;
import org.springframework.data.mongodb.repository.aot.QueryInteraction;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.repository.aot.generate.QueryMetadata;

class NearQueryInteraction
extends MongoInteraction
implements QueryMetadata {
    private final MongoInteraction.InteractionType interactionType = MongoInteraction.InteractionType.QUERY;
    private final QueryInteraction query;
    private final MongoParameters parameters;

    NearQueryInteraction(QueryInteraction query, MongoParameters parameters) {
        this.query = query;
        this.parameters = parameters;
    }

    @Override
    MongoInteraction.InteractionType getExecutionType() {
        return this.interactionType;
    }

    public QueryInteraction getQuery() {
        return this.query;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
        serialized.put("near", "?%s".formatted(this.parameters.getNearIndex()));
        if (this.parameters.getRangeIndex() != -1) {
            serialized.put("minDistance", "?%s".formatted(this.parameters.getRangeIndex()));
            serialized.put("maxDistance", "?%s".formatted(this.parameters.getRangeIndex()));
        } else if (this.parameters.getMaxDistanceIndex() != -1) {
            serialized.put("minDistance", "?%s".formatted(this.parameters.getMaxDistanceIndex()));
        }
        Object filter = this.query.serialize().get("filter");
        if (filter != null) {
            serialized.put("filter", filter);
        }
        return serialized;
    }
}

