/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.mapping.ShardingStrategy;
import org.springframework.util.ObjectUtils;

public class ShardKey {
    private static final ShardKey NONE = new ShardKey(Collections.emptyList(), null, true);
    private final List<String> propertyNames;
    private final @Nullable ShardingStrategy shardingStrategy;
    private final boolean immutable;

    private ShardKey(List<String> propertyNames, @Nullable ShardingStrategy shardingStrategy, boolean immutable) {
        this.propertyNames = propertyNames;
        this.shardingStrategy = shardingStrategy;
        this.immutable = immutable;
    }

    public int size() {
        return this.propertyNames.size();
    }

    public Collection<String> getPropertyNames() {
        return this.propertyNames;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isSharded() {
        return !this.propertyNames.isEmpty();
    }

    public Document getDocument() {
        Document doc = new Document();
        for (String field : this.propertyNames) {
            doc.append(field, this.shardingValue());
        }
        return doc;
    }

    private Object shardingValue() {
        return ObjectUtils.nullSafeEquals((Object)((Object)ShardingStrategy.HASH), (Object)((Object)this.shardingStrategy)) ? "hash" : Integer.valueOf(1);
    }

    public static ShardKey none() {
        return NONE;
    }

    public static ShardKey range(String ... propertyNames) {
        return new ShardKey(Arrays.asList(propertyNames), ShardingStrategy.RANGE, false);
    }

    public static ShardKey hash(String ... propertyNames) {
        return new ShardKey(Arrays.asList(propertyNames), ShardingStrategy.HASH, false);
    }

    public static ShardKey immutable(ShardKey shardKey) {
        if (shardKey.isImmutable()) {
            return shardKey;
        }
        return new ShardKey(shardKey.propertyNames, shardKey.shardingStrategy, true);
    }
}

