/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ObjectPath {
    static final ObjectPath ROOT = new ObjectPath();
    private final @Nullable ObjectPath parent;
    private final @Nullable Object object;
    private final @Nullable Object idValue;
    private final Lazy<String> collection;

    private ObjectPath() {
        this.parent = null;
        this.object = null;
        this.idValue = null;
        this.collection = Lazy.empty();
    }

    private ObjectPath(ObjectPath parent, Object object, @Nullable Object idValue, Lazy<String> collection) {
        this.parent = parent;
        this.object = object;
        this.idValue = idValue;
        this.collection = collection;
    }

    ObjectPath push(Object object, MongoPersistentEntity<?> entity, @Nullable Object id) {
        Assert.notNull((Object)object, (String)"Object must not be null");
        Assert.notNull(entity, (String)"MongoPersistentEntity must not be null");
        return new ObjectPath(this, object, id, (Lazy<String>)Lazy.of(entity::getCollection));
    }

    <T> @Nullable T getPathItem(Object id, String collection, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.hasText((String)collection, (String)"Collection name must not be null");
        Assert.notNull(type, (String)"Type must not be null");
        ObjectPath current = this;
        while (current != null) {
            Object object = current.getObject();
            if (object != null && current.getIdValue() != null && collection.equals(current.getCollection()) && id.equals(current.getIdValue()) && ClassUtils.isAssignable(type, object.getClass())) {
                return type.cast(object);
            }
            current = current.parent;
        }
        return null;
    }

    @Nullable Object getCurrentObject() {
        return this.getObject();
    }

    private @Nullable Object getObject() {
        return this.object;
    }

    private @Nullable Object getIdValue() {
        return this.idValue;
    }

    private String getCollection() {
        return (String)this.collection.get();
    }

    public String toString() {
        if (this.parent == null) {
            return "[empty]";
        }
        ArrayList<String> strings = new ArrayList<String>();
        ObjectPath current = this;
        while (current != null) {
            strings.add(ObjectUtils.nullSafeToString((Object)current.getObject()));
            current = current.parent;
        }
        return StringUtils.collectionToDelimitedString(strings, (String)" -> ");
    }
}

