/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OutOperation
implements AggregationOperation {
    private final @Nullable String databaseName;
    private final String collectionName;
    private final @Nullable CollectionOptions.TimeSeriesOptions timeSeriesOptions;

    public OutOperation(String outCollectionName) {
        this(null, outCollectionName, null);
    }

    private OutOperation(@Nullable String databaseName, String collectionName, @Nullable CollectionOptions.TimeSeriesOptions timeSeriesOptions) {
        Assert.notNull((Object)collectionName, (String)"Collection name must not be null");
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.timeSeriesOptions = timeSeriesOptions;
    }

    @Contract(value="_ -> new")
    public OutOperation in(@Nullable String database) {
        return new OutOperation(database, this.collectionName, this.timeSeriesOptions);
    }

    @Contract(value="_ -> new")
    public OutOperation timeSeries(CollectionOptions.TimeSeriesOptions timeSeriesOptions) {
        Assert.notNull((Object)timeSeriesOptions, (String)"TimeSeriesOptions must not be null");
        return new OutOperation(this.databaseName, this.collectionName, timeSeriesOptions);
    }

    @Contract(value="_ -> new")
    public OutOperation timeSeries(String timeField) {
        Assert.hasText((String)timeField, (String)"TimeField must not be null or empty");
        return this.timeSeries(CollectionOptions.TimeSeriesOptions.timeSeries(timeField));
    }

    @Contract(value="_, _, _ -> new")
    public OutOperation timeSeries(String timeField, @Nullable String metaField, @Nullable Granularity granularity) {
        Assert.hasText((String)timeField, (String)"TimeField must not be null or empty");
        CollectionOptions.TimeSeriesOptions options = CollectionOptions.TimeSeriesOptions.timeSeries(timeField).metaField(metaField).granularity(granularity != null ? granularity : Granularity.DEFAULT);
        return this.timeSeries(options);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        if (!StringUtils.hasText((String)this.databaseName) && this.timeSeriesOptions == null) {
            return new Document(this.getOperator(), (Object)this.collectionName);
        }
        Document outDocument = new Document("coll", (Object)this.collectionName);
        if (StringUtils.hasText((String)this.databaseName)) {
            outDocument.put("db", (Object)this.databaseName);
        }
        if (this.timeSeriesOptions != null) {
            Document timeSeriesDoc = new Document("timeField", (Object)this.timeSeriesOptions.getTimeField());
            if (StringUtils.hasText((String)this.timeSeriesOptions.getMetaField())) {
                timeSeriesDoc.put("metaField", (Object)this.timeSeriesOptions.getMetaField());
            }
            if (this.timeSeriesOptions.getGranularity() != null && this.timeSeriesOptions.getGranularity() != Granularity.DEFAULT) {
                timeSeriesDoc.put("granularity", (Object)this.timeSeriesOptions.getGranularity().name().toLowerCase());
            }
            if (this.timeSeriesOptions.getSpan() != null && this.timeSeriesOptions.getSpan().time() != null) {
                long spanSeconds = this.timeSeriesOptions.getSpan().time().getSeconds();
                timeSeriesDoc.put("bucketMaxSpanSeconds", (Object)spanSeconds);
                timeSeriesDoc.put("bucketRoundingSeconds", (Object)spanSeconds);
            }
            outDocument.put("timeseries", (Object)timeSeriesDoc);
        }
        return new Document(this.getOperator(), (Object)outDocument);
    }

    @Override
    public String getOperator() {
        return "$out";
    }
}

