/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.QuerydslPredicateExecutorSupport;
import org.springframework.data.mongodb.repository.support.ReactiveFluentQuerySupport;
import org.springframework.data.mongodb.repository.support.ReactiveSpringDataMongodbQuery;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQuerydslMongoPredicateExecutor<T>
extends QuerydslPredicateExecutorSupport<T>
implements ReactiveQuerydslPredicateExecutor<T> {
    private final ReactiveMongoOperations mongoOperations;

    public ReactiveQuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, ReactiveMongoOperations mongoOperations) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public ReactiveQuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, ReactiveMongoOperations mongoOperations, EntityPathResolver resolver) {
        super(mongoOperations.getConverter(), ReactiveQuerydslMongoPredicateExecutor.pathBuilderFor(resolver.createPath(entityInformation.getJavaType())), entityInformation);
        this.mongoOperations = mongoOperations;
    }

    public Mono<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetchOne();
    }

    public Flux<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetch();
    }

    public Flux<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(orders, (String)"Order specifiers must not be null");
        return ((ReactiveSpringDataMongodbQuery)this.createQueryFor(predicate).orderBy(orders)).fetch();
    }

    public Flux<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return this.applySorting(this.createQueryFor(predicate), sort).fetch();
    }

    public Flux<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null");
        return ((ReactiveSpringDataMongodbQuery)this.createQuery().orderBy(orders)).fetch();
    }

    public Mono<Long> count(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetchCount();
    }

    public Mono<Boolean> exists(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetchCount().map(it -> it != 0L);
    }

    public <S extends T, R, P extends Publisher<R>> P findBy(Predicate predicate, Function<FluentQuery.ReactiveFluentQuery<S>, P> queryFunction) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return (P)((Publisher)queryFunction.apply(new ReactiveFluentQuerydsl(predicate, this.typeInformation().getJavaType())));
    }

    private ReactiveSpringDataMongodbQuery<T> createQueryFor(Predicate predicate) {
        return (ReactiveSpringDataMongodbQuery)this.createQuery().where(predicate);
    }

    private ReactiveSpringDataMongodbQuery<T> createQuery() {
        Class javaType = this.typeInformation().getJavaType();
        return new ReactiveSpringDataMongodbQuery(this.mongoOperations, javaType, javaType, this.mongoOperations.getCollectionName(javaType), it -> {});
    }

    private ReactiveSpringDataMongodbQuery<T> applySorting(ReactiveSpringDataMongodbQuery<T> query, Sort sort) {
        this.toOrderSpecifiers(sort).forEach(arg_0 -> query.orderBy(arg_0));
        return query;
    }

    class ReactiveFluentQuerydsl<T>
    extends ReactiveFluentQuerySupport<Predicate, T> {
        ReactiveFluentQuerydsl(Predicate predicate, Class<T> resultType) {
            this(predicate, Sort.unsorted(), 0, resultType, Collections.emptyList());
        }

        ReactiveFluentQuerydsl(Predicate predicate, Sort sort, int limit, Class<T> resultType, List<String> fieldsToInclude) {
            super(predicate, sort, limit, resultType, fieldsToInclude);
        }

        protected <R> ReactiveFluentQuerydsl<R> create(Predicate predicate, Sort sort, int limit, Class<R> resultType, List<String> fieldsToInclude) {
            return new ReactiveFluentQuerydsl<R>(predicate, sort, limit, resultType, fieldsToInclude);
        }

        public Mono<T> one() {
            return this.createQuery().fetchOne();
        }

        public Mono<T> first() {
            return this.createQuery().fetchFirst();
        }

        public Flux<T> all() {
            return this.createQuery().fetch();
        }

        public Mono<Window<T>> scroll(ScrollPosition scrollPosition) {
            return this.createQuery().scroll(scrollPosition);
        }

        public Mono<Page<T>> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            return this.createQuery().fetchPage(pageable);
        }

        public Mono<Long> count() {
            return this.createQuery().fetchCount();
        }

        public Mono<Boolean> exists() {
            return this.count().map(it -> it > 0L).defaultIfEmpty((Object)false);
        }

        private ReactiveSpringDataMongodbQuery<T> createQuery() {
            return (ReactiveSpringDataMongodbQuery)new ReactiveSpringDataMongodbQuery(ReactiveQuerydslMongoPredicateExecutor.this.mongoOperations, ReactiveQuerydslMongoPredicateExecutor.this.typeInformation().getJavaType(), this.getResultType(), ReactiveQuerydslMongoPredicateExecutor.this.mongoOperations.getCollectionName(ReactiveQuerydslMongoPredicateExecutor.this.typeInformation().getJavaType()), this::customize).where((Predicate)this.getPredicate());
        }

        private void customize(BasicQuery query) {
            List<String> fieldsToInclude = this.getFieldsToInclude();
            if (!fieldsToInclude.isEmpty()) {
                Document fields = new Document();
                fieldsToInclude.forEach(field -> fields.put(field, (Object)1));
                query.setFieldsObject(fields);
            }
            if (this.getSort().isSorted()) {
                query.with(this.getSort());
            }
            query.limit(this.getLimit());
        }
    }
}

