/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.SystemVariable;
import org.springframework.util.Assert;

public class ObjectOperators {
    public static ObjectOperatorFactory valueOf(String fieldReference) {
        return new ObjectOperatorFactory(Fields.field(fieldReference));
    }

    public static ObjectOperatorFactory valueOf(AggregationExpression expression) {
        return new ObjectOperatorFactory(expression);
    }

    public static ObjectOperatorFactory valueOf(SystemVariable variable) {
        return new ObjectOperatorFactory(Fields.field(variable.getName(), variable.getTarget()));
    }

    public static AggregationExpression getValueOf(String fieldName) {
        return new ObjectOperatorFactory(SystemVariable.CURRENT).getField(fieldName);
    }

    public static AggregationExpression setValueTo(String fieldName, Object value) {
        return new ObjectOperatorFactory(SystemVariable.CURRENT).setField(fieldName).toValue(value);
    }

    public static class ObjectOperatorFactory {
        private final Object value;

        public ObjectOperatorFactory(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.value = value;
        }

        public MergeObjects merge() {
            return MergeObjects.merge(this.value);
        }

        public MergeObjects mergeWith(Object ... values) {
            return this.merge().mergeWith(values);
        }

        public MergeObjects mergeWithValuesOf(String ... fieldReferences) {
            return this.merge().mergeWithValuesOf(fieldReferences);
        }

        public MergeObjects mergeWithValuesOf(AggregationExpression ... expression) {
            return this.merge().mergeWithValuesOf(expression);
        }

        public ObjectToArray toArray() {
            return ObjectToArray.toArray(this.value);
        }

        public GetField getField(String fieldName) {
            return GetField.getField(Fields.field(fieldName)).of(this.value);
        }

        public SetField setField(String fieldName) {
            return SetField.field(Fields.field(fieldName)).input(this.value);
        }

        public AggregationExpression removeField(String fieldName) {
            return SetField.field(fieldName).input(this.value).toValue(SystemVariable.REMOVE);
        }
    }

    public static class GetField
    extends AbstractAggregationExpression {
        protected GetField(Object value) {
            super(value);
        }

        public static GetField getField(String fieldName) {
            return new GetField(Collections.singletonMap("field", fieldName));
        }

        public static GetField getField(Field field) {
            return new GetField(Collections.singletonMap("field", field));
        }

        public GetField of(String fieldRef) {
            return this.of(Fields.field(fieldRef));
        }

        public GetField of(AggregationExpression expression) {
            return this.of((Object)expression);
        }

        private GetField of(Object fieldRef) {
            return new GetField(this.append("input", fieldRef));
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Object t;
            if (this.isArgumentMap() && (t = this.get("field")) instanceof Field) {
                Field field = (Field)t;
                return new GetField(this.append("field", context.getReference(field).getRaw())).toDocument(context);
            }
            return super.toDocument(context);
        }

        @Override
        protected String getMongoMethod() {
            return "$getField";
        }
    }

    public static class SetField
    extends AbstractAggregationExpression {
        protected SetField(Object value) {
            super(value);
        }

        public static SetField field(String fieldName) {
            return new SetField(Collections.singletonMap("field", fieldName));
        }

        public static SetField field(Field field) {
            return new SetField(Collections.singletonMap("field", field));
        }

        public SetField input(String fieldRef) {
            return this.input(Fields.field(fieldRef));
        }

        public SetField input(AggregationExpression expression) {
            return this.input((Object)expression);
        }

        private SetField input(Object fieldRef) {
            return new SetField(this.append("input", fieldRef));
        }

        public SetField toValueOf(String fieldReference) {
            return this.toValue(Fields.field(fieldReference));
        }

        public SetField toValueOf(AggregationExpression expression) {
            return this.toValue(expression);
        }

        public SetField toValue(Object value) {
            return new SetField(this.append("value", value));
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Object t = this.get("field");
            if (t instanceof Field) {
                Field field = (Field)t;
                return new SetField(this.append("field", context.getReference(field).getRaw())).toDocument(context);
            }
            return super.toDocument(context);
        }

        @Override
        protected String getMongoMethod() {
            return "$setField";
        }
    }

    public static class ObjectToArray
    extends AbstractAggregationExpression {
        private ObjectToArray(Object value) {
            super(value);
        }

        public static ObjectToArray valueOfToArray(String fieldReference) {
            return ObjectToArray.toArray(Fields.field(fieldReference));
        }

        public static ObjectToArray valueOfToArray(AggregationExpression expression) {
            return ObjectToArray.toArray(expression);
        }

        public static ObjectToArray toArray(Object value) {
            return new ObjectToArray(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$objectToArray";
        }
    }

    public static class MergeObjects
    extends AbstractAggregationExpression {
        private MergeObjects(Object value) {
            super(value);
        }

        public static MergeObjects merge(Object ... values) {
            return new MergeObjects(Arrays.asList(values));
        }

        public static MergeObjects mergeValuesOf(String ... fieldReferences) {
            return MergeObjects.merge(Arrays.stream(fieldReferences).map(Fields::field).toArray());
        }

        public static MergeObjects mergeValuesOf(AggregationExpression ... expressions) {
            return MergeObjects.merge(expressions);
        }

        public MergeObjects mergeWithValuesOf(String ... fieldReferences) {
            return this.mergeWith(Arrays.stream(fieldReferences).map(Fields::field).toArray());
        }

        public MergeObjects mergeWithValuesOf(AggregationExpression ... expression) {
            return this.mergeWith(expression);
        }

        public MergeObjects mergeWith(Object ... values) {
            return new MergeObjects(this.append(Arrays.asList(values)));
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            return super.toDocument(this.potentiallyExtractSingleValue(value), context);
        }

        private Object potentiallyExtractSingleValue(Object value) {
            Collection collection;
            if (value instanceof Collection && (collection = (Collection)value).size() == 1) {
                return collection.iterator().next();
            }
            return value;
        }

        @Override
        protected String getMongoMethod() {
            return "$mergeObjects";
        }
    }
}

