/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.ForwardingCloseableIterator;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.PredicateQueryEngine;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.map.KeySpaceStore;
import org.springframework.data.map.MapKeySpaceStore;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

public class MapKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final KeySpaceStore store;

    public MapKeyValueAdapter() {
        this(MapKeySpaceStore.create());
    }

    public MapKeyValueAdapter(QueryEngine<? extends KeyValueAdapter, ?, ?> engine) {
        this(MapKeySpaceStore.create(), engine);
    }

    public MapKeyValueAdapter(Class<? extends Map> mapType) {
        this(MapKeySpaceStore.of(mapType));
    }

    public MapKeyValueAdapter(Class<? extends Map> mapType, SortAccessor<Comparator<?>> sortAccessor) {
        this(MapKeySpaceStore.of(mapType), new PredicateQueryEngine(sortAccessor));
    }

    public MapKeyValueAdapter(Class<? extends Map> mapType, QueryEngine<? extends KeyValueAdapter, ?, ?> engine) {
        this(MapKeySpaceStore.of(mapType), engine);
    }

    public MapKeyValueAdapter(Map<String, Map<Object, Object>> store) {
        this(MapKeySpaceStore.of(store));
    }

    public MapKeyValueAdapter(Map<String, Map<Object, Object>> store, QueryEngine<? extends KeyValueAdapter, ?, ?> engine) {
        this(MapKeySpaceStore.of(store), engine);
    }

    public MapKeyValueAdapter(KeySpaceStore store) {
        this(store, new PredicateQueryEngine());
    }

    public MapKeyValueAdapter(KeySpaceStore store, @Nullable QueryEngine<? extends KeyValueAdapter, ?, ?> engine) {
        super(engine);
        Assert.notNull((Object)store, (String)"KeyspaceStore must not be null");
        this.store = store;
    }

    @Override
    public @Nullable Object put(Object id, Object item, String keyspace) {
        Assert.notNull((Object)id, (String)"Cannot add item with null id");
        Assert.notNull((Object)keyspace, (String)"Cannot add item for null collection");
        return this.getKeySpaceMap(keyspace).put(id, item);
    }

    @Override
    public boolean contains(Object id, String keyspace) {
        return this.get(id, keyspace) != null;
    }

    @Override
    public long count(String keyspace) {
        return this.getKeySpaceMap(keyspace).size();
    }

    @Override
    public @Nullable Object get(Object id, String keyspace) {
        Assert.notNull((Object)id, (String)"Cannot get item with null id");
        return this.getKeySpaceMap(keyspace).get(id);
    }

    @Override
    public @Nullable Object delete(Object id, String keyspace) {
        Assert.notNull((Object)id, (String)"Cannot delete item with null id");
        return this.getKeySpaceMap(keyspace).remove(id);
    }

    public Collection<Object> getAllOf(String keyspace) {
        return this.getKeySpaceMap(keyspace).values();
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> entries(String keyspace) {
        return new ForwardingCloseableIterator<Map.Entry<Object, Object>>(this.getKeySpaceMap(keyspace).entrySet().iterator());
    }

    @Override
    public void deleteAllOf(String keyspace) {
        this.getKeySpaceMap(keyspace).clear();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    public void destroy() throws Exception {
        this.clear();
    }

    protected Map<Object, Object> getKeySpaceMap(String keyspace) {
        Assert.notNull((Object)keyspace, (String)"Collection must not be null for lookup");
        return this.store.getKeySpace(keyspace);
    }
}

