/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.event;

import java.io.Serializable;
import org.springframework.context.ApplicationEvent;

public class KeyValueEvent<T>
extends ApplicationEvent {
    private static final long serialVersionUID = -7128527253428193044L;
    private final String keyspace;

    protected KeyValueEvent(Object source, String keyspace) {
        super(source);
        this.keyspace = keyspace;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String toString() {
        return "KeyValueEvent [keyspace=" + this.keyspace + ", source=" + this.getSource() + "]";
    }

    public static <T> BeforeGetEvent<T> beforeGet(Serializable id, String keySpace, Class<T> type) {
        return new BeforeGetEvent<T>(id, keySpace, type);
    }

    public static <T> AfterGetEvent<T> afterGet(Serializable id, String keySpace, Class<T> type, T value) {
        return new AfterGetEvent<T>(id, keySpace, type, value);
    }

    public static <T> BeforeInsertEvent<T> beforeInsert(Serializable id, String keySpace, Class<? extends T> type, T value) {
        return new BeforeInsertEvent<T>(id, keySpace, type, value);
    }

    public static <T> AfterInsertEvent<T> afterInsert(Serializable id, String keySpace, Class<? extends T> type, T value) {
        return new AfterInsertEvent<T>(id, keySpace, type, value);
    }

    public static <T> BeforeUpdateEvent<T> beforeUpdate(Serializable id, String keySpace, Class<? extends T> type, T value) {
        return new BeforeUpdateEvent<T>(id, keySpace, type, value);
    }

    public static <T> AfterUpdateEvent<T> afterUpdate(Serializable id, String keySpace, Class<? extends T> type, T actualValue, Object previousValue) {
        return new AfterUpdateEvent<T>(id, keySpace, type, actualValue, previousValue);
    }

    public static <T> BeforeDropKeySpaceEvent<T> beforeDropKeySpace(String keySpace, Class<? extends T> type) {
        return new BeforeDropKeySpaceEvent<T>(keySpace, type);
    }

    public static <T> AfterDropKeySpaceEvent<T> afterDropKeySpace(String keySpace, Class<? extends T> type) {
        return new AfterDropKeySpaceEvent<T>(keySpace, type);
    }

    public static <T> BeforeDeleteEvent<T> beforeDelete(Serializable id, String keySpace, Class<? extends T> type) {
        return new BeforeDeleteEvent<T>(id, keySpace, type);
    }

    public static <T> AfterDeleteEvent<T> afterDelete(Serializable id, String keySpace, Class<? extends T> type, T value) {
        return new AfterDeleteEvent<T>(id, keySpace, type, value);
    }

    public static class AfterDropKeySpaceEvent<T>
    extends KeyValueEvent<T> {
        public AfterDropKeySpaceEvent(String keySpace, Class<? extends T> type) {
            super(type, keySpace);
        }

        public Class<T> getSource() {
            return (Class)super.getSource();
        }
    }

    public static class BeforeDropKeySpaceEvent<T>
    extends KeyValueEvent<T> {
        public BeforeDropKeySpaceEvent(String keySpace, Class<? extends T> type) {
            super(type, keySpace);
        }

        public Class<T> getSource() {
            return (Class)super.getSource();
        }
    }

    public static class AfterDeleteEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public AfterDeleteEvent(Serializable key, String keySpace, Class<? extends T> type, T payload) {
            super(key, keySpace, type, payload);
        }
    }

    public static class BeforeDeleteEvent<T>
    extends KeyBasedEvent<T> {
        public BeforeDeleteEvent(Serializable key, String keySpace, Class<? extends T> type) {
            super(key, keySpace, type);
        }
    }

    public static class AfterUpdateEvent<T>
    extends KeyBasedEventWithPayload<T> {
        private final Object existing;

        public AfterUpdateEvent(Serializable key, String keySpace, Class<? extends T> type, T payload, Object existing) {
            super(key, keySpace, type, payload);
            this.existing = existing;
        }

        public Object before() {
            return this.existing;
        }

        public T after() {
            return (T)this.getPayload();
        }
    }

    public static class BeforeUpdateEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public BeforeUpdateEvent(Serializable key, String keySpace, Class<? extends T> type, T payload) {
            super(key, keySpace, type, payload);
        }
    }

    public static class AfterInsertEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public AfterInsertEvent(Serializable key, String keySpace, Class<? extends T> type, T payload) {
            super(key, keySpace, type, payload);
        }
    }

    public static class BeforeInsertEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public BeforeInsertEvent(Serializable key, String keySpace, Class<? extends T> type, T payload) {
            super(key, keySpace, type, payload);
        }
    }

    public static class AfterGetEvent<T>
    extends KeyBasedEventWithPayload<T> {
        protected AfterGetEvent(Serializable key, String keyspace, Class<T> type, T payload) {
            super(key, keyspace, type, payload);
        }
    }

    public static class BeforeGetEvent<T>
    extends KeyBasedEvent<T> {
        protected BeforeGetEvent(Serializable key, String keySpace, Class<T> type) {
            super(key, keySpace, type);
        }
    }

    static abstract class KeyBasedEventWithPayload<T>
    extends KeyBasedEvent<T> {
        private final T payload;

        public KeyBasedEventWithPayload(Serializable key, String keySpace, Class<? extends T> type, T payload) {
            super(key, keySpace, type);
            this.payload = payload;
        }

        public T getPayload() {
            return this.payload;
        }
    }

    static abstract class KeyBasedEvent<T>
    extends KeyValueEvent<T> {
        private Serializable key;
        private Class<? extends T> type;

        protected KeyBasedEvent(Serializable key, String keySpace, Class<? extends T> type) {
            super(type, keySpace);
            this.key = key;
        }

        public Serializable getKey() {
            return this.key;
        }

        public Serializable getSource() {
            return this.getKey();
        }

        public Class<? extends T> getType() {
            return this.type;
        }
    }
}

