/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.util.Predicates;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class JpqlQueryBuilder {
    private JpqlQueryBuilder() {
    }

    public static Entity entity(JpaEntityMetadata<?> from) {
        return new Entity(from.getJavaType(), from.getEntityName(), JpqlQueryBuilder.getAlias(from.getJavaType().getSimpleName(), Predicates.isTrue(), () -> "r"));
    }

    public static Join innerJoin(Origin origin, String path) {
        return new Join(origin, "INNER JOIN", path);
    }

    public static Join leftJoin(Origin origin, String path) {
        return new Join(origin, "LEFT JOIN", path);
    }

    public static SelectStep selectFrom(final Entity from) {
        return new SelectStep(){
            boolean distinct = false;

            @Override
            public SelectStep distinct() {
                this.distinct = true;
                return this;
            }

            @Override
            public Select entity() {
                return new Select(this.postProcess(new EntitySelection(from)), from);
            }

            @Override
            public Select count() {
                return new Select(new CountSelection(from, this.distinct), from);
            }

            @Override
            public Select instantiate(String resultType, Collection<? extends Expression> paths) {
                return new Select(this.postProcess(new ConstructorExpression(resultType, new Multiselect(from, paths))), from);
            }

            @Override
            public Select select(Collection<? extends Expression> paths) {
                return new Select(this.postProcess(new Multiselect(from, paths)), from);
            }

            @Override
            public Select select(Selection selection) {
                return new Select(this.postProcess(selection), from);
            }

            Selection postProcess(Selection selection) {
                return this.distinct ? new DistinctSelection(selection) : selection;
            }
        };
    }

    private static String getAlias(String from, java.util.function.Predicate<String> predicate, Supplier<String> fallback) {
        char[] charArray;
        StringBuilder builder = new StringBuilder();
        char[] cArray = charArray = from.toLowerCase(Locale.ROOT).toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isJavaIdentifierPart(c)) break;
            builder.append(c);
            ++n2;
        }
        if (builder.isEmpty()) {
            return fallback.get();
        }
        String identifier = builder.toString();
        String firstChar = identifier.substring(0, 1);
        if (predicate.test(firstChar)) {
            return firstChar;
        }
        int i = 0;
        while (i < 10) {
            String candidate = firstChar + "_" + i;
            if (predicate.test(candidate)) {
                return candidate;
            }
            ++i;
        }
        return fallback.get();
    }

    public static Expression function(String function, Expression ... arguments) {
        return new FunctionExpression(function, Arrays.asList(arguments));
    }

    public static Predicate nested(Predicate predicate) {
        return new NestedPredicate(predicate);
    }

    public static Expression expression(Origin source, PropertyPath path) {
        return new PathAndOrigin(path, source, false);
    }

    public static Expression expression(String expression) {
        Assert.hasText((String)expression, (String)"Expression must not be empty or null");
        return new LiteralExpression(expression);
    }

    public static Expression literal(Number literal) {
        return new LiteralExpression(literal.toString());
    }

    public static Expression literal(String literal) {
        return new StringLiteralExpression(literal);
    }

    public static Expression parameter(String parameter) {
        Assert.hasText((String)parameter, (String)"Parameter must not be empty or null");
        return new ParameterExpression(new ParameterPlaceholder(parameter));
    }

    public static Expression parameter(ParameterPlaceholder placeholder) {
        return new ParameterExpression(placeholder);
    }

    public static Expression orderBy(Expression sortExpression) {
        return new OrderExpression(sortExpression, null, Sort.NullHandling.NATIVE);
    }

    public static Expression orderBy(Expression sortExpression, Sort.Order order) {
        return new OrderExpression(sortExpression, order.getDirection(), order.getNullHandling());
    }

    public static Expression orderBy(Expression sortExpression, Sort.Direction direction) {
        return new OrderExpression(sortExpression, direction, Sort.NullHandling.NATIVE);
    }

    public static WhereStep where(Origin source, PropertyPath path) {
        return JpqlQueryBuilder.where(JpqlQueryBuilder.expression(source, path));
    }

    public static WhereStep where(final Expression rhs) {
        return new WhereStep(){

            @Override
            public Predicate between(Expression lower, Expression upper) {
                return new BetweenPredicate(rhs, lower, upper);
            }

            @Override
            public Predicate gt(Expression value) {
                return new OperatorPredicate(rhs, ">", value);
            }

            @Override
            public Predicate gte(Expression value) {
                return new OperatorPredicate(rhs, ">=", value);
            }

            @Override
            public Predicate lt(Expression value) {
                return new OperatorPredicate(rhs, "<", value);
            }

            @Override
            public Predicate lte(Expression value) {
                return new OperatorPredicate(rhs, "<=", value);
            }

            @Override
            public Predicate isNull() {
                return new LhsPredicate(rhs, "IS NULL");
            }

            @Override
            public Predicate isNotNull() {
                return new LhsPredicate(rhs, "IS NOT NULL");
            }

            @Override
            public Predicate isTrue() {
                return new LhsPredicate(rhs, "= TRUE");
            }

            @Override
            public Predicate isFalse() {
                return new LhsPredicate(rhs, "= FALSE");
            }

            @Override
            public Predicate isEmpty() {
                return new CollectionLhsPredicate(rhs, "IS EMPTY");
            }

            @Override
            public Predicate isNotEmpty() {
                return new CollectionLhsPredicate(rhs, "IS NOT EMPTY");
            }

            @Override
            public Predicate in(Expression value) {
                return new InPredicate(rhs, "IN", value);
            }

            @Override
            public Predicate notIn(Expression value) {
                return new InPredicate(rhs, "NOT IN", value);
            }

            @Override
            public Predicate memberOf(Expression value) {
                return new CollectionOperatorPredicate(rhs, "MEMBER OF", value);
            }

            @Override
            public Predicate notMemberOf(Expression value) {
                return new CollectionOperatorPredicate(rhs, "NOT MEMBER OF", value);
            }

            @Override
            public Predicate like(Expression value, String escape) {
                return new LikePredicate(rhs, "LIKE", value, escape);
            }

            @Override
            public Predicate notLike(Expression value, String escape) {
                return new LikePredicate(rhs, "NOT LIKE", value, escape);
            }

            @Override
            public Predicate eq(Expression value) {
                return new OperatorPredicate(rhs, "=", value);
            }

            @Override
            public Predicate neq(Expression value) {
                return new OperatorPredicate(rhs, "!=", value);
            }
        };
    }

    @Nullable
    public static Predicate and(List<Predicate> intermediate) {
        Predicate predicate = null;
        for (Predicate other : intermediate) {
            predicate = predicate == null ? other : predicate.and(other);
        }
        return predicate;
    }

    @Nullable
    public static Predicate or(List<Predicate> intermediate) {
        Predicate predicate = null;
        for (Predicate other : intermediate) {
            predicate = predicate == null ? other : predicate.or(other);
        }
        return predicate;
    }

    static PathAndOrigin path(Origin origin, String path) {
        if (origin instanceof Entity) {
            Entity entity = (Entity)origin;
            PropertyPath from = PropertyPath.from((String)path, entity.entityClass);
            return new PathAndOrigin(from, entity, false);
        }
        if (origin instanceof Join) {
            Join join = (Join)origin;
            Origin parent = join.source;
            ArrayList<String> segments = new ArrayList<String>();
            segments.add(join.path);
            while (!(parent instanceof Entity)) {
                if (parent instanceof Join) {
                    Join parentJoin = (Join)parent;
                    parent = parentJoin.source;
                    segments.add(parentJoin.path);
                    continue;
                }
                parent = null;
            }
            Collections.reverse(segments);
            segments.add(path);
            PathAndOrigin joinedPath = JpqlQueryBuilder.path(parent, StringUtils.collectionToDelimitedString(segments, (String)"."));
            return new PathAndOrigin(joinedPath.path().getLeafProperty(), origin, false);
        }
        throw new IllegalStateException("\ud83d\ude48 Unsupported origin type: " + String.valueOf(origin));
    }

    public static abstract class AbstractJpqlQuery {
        @Nullable
        private Predicate where;

        public AbstractJpqlQuery where(Predicate predicate) {
            this.where = predicate;
            return this;
        }

        @Nullable
        public Predicate getWhere() {
            return this.where;
        }

        abstract String render();

        public String toString() {
            return this.render();
        }
    }

    public static interface AliasedExpression
    extends Expression {
        public String getAlias();
    }

    record AndPredicate(Predicate left, Predicate right) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "%s AND %s".formatted(this.left.render(context), this.right.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record BetweenPredicate(Expression path, Expression lower, Expression upper) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "%s BETWEEN %s AND %s".formatted(this.path.render(context), this.lower.render(context), this.upper.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record CollectionLhsPredicate(Expression path, String operator) implements Predicate
    {
        CollectionLhsPredicate {
            PathAndOrigin p;
            if (path instanceof PathAndOrigin && (p = (PathAndOrigin)path).onTheJoin()) {
                path = p.parent();
            }
        }

        @Override
        public String render(RenderContext context) {
            return "%s %s".formatted(this.path.render(context), this.operator);
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record CollectionOperatorPredicate(Expression path, String operator, Expression predicate) implements Predicate
    {
        CollectionOperatorPredicate {
            PathAndOrigin p;
            if (path instanceof PathAndOrigin && (p = (PathAndOrigin)path).onTheJoin()) {
                path = p.parent();
            }
        }

        @Override
        public String render(RenderContext context) {
            return "%s %s %s".formatted(this.predicate.render(context), this.operator, this.path.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    static class ConstructorContext
    extends RenderContext {
        ConstructorContext(RenderContext rootContext) {
            super(rootContext.aliases);
        }

        @Override
        public boolean isConstructorContext() {
            return true;
        }
    }

    record ConstructorExpression(String resultType, Multiselect multiselect) implements Selection,
    Expression
    {
        @Override
        public String render(RenderContext context) {
            return "new %s(%s)".formatted(this.resultType, this.multiselect.render(new ConstructorContext(context)));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record CountSelection(Entity source, boolean distinct) implements Selection
    {
        @Override
        public String render(RenderContext context) {
            return "COUNT(%s%s)".formatted(this.distinct ? "DISTINCT " : "", context.getAlias(this.source));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record DefaultAliasedExpression(Expression delegate, String alias) implements AliasedExpression
    {
        @Override
        public String render(RenderContext context) {
            return this.delegate.render(context);
        }

        @Override
        public String getAlias() {
            return this.alias();
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record DistinctSelection(Selection selection) implements Selection
    {
        @Override
        public String render(RenderContext context) {
            return "DISTINCT %s".formatted(this.selection.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    public static final class Entity
    implements Origin {
        private final Class<?> entityClass;
        private final String entity;
        private final String alias;

        Entity(Class<?> entityClass, String entity, String alias) {
            this.entityClass = entityClass;
            this.entity = entity;
            this.alias = alias;
        }

        @Override
        public String getName() {
            return this.entity;
        }

        @Override
        public String getPath() {
            return this.getName();
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Entity that = (Entity)obj;
            return Objects.equals(this.entity, that.entity) && Objects.equals(this.entityClass, that.entityClass) && Objects.equals(this.alias, that.alias);
        }

        public int hashCode() {
            return Objects.hash(this.entity, this.entityClass, this.alias);
        }

        public String toString() {
            return "Entity[entity=" + this.entity + ", className=" + this.entityClass.getName() + ", alias=" + this.alias + "]";
        }
    }

    record EntitySelection(Entity source) implements Selection,
    Expression
    {
        @Override
        public String render(RenderContext context) {
            return context.getAlias(this.source);
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    public static interface Expression
    extends Renderable {
        default public AliasedExpression as(String alias) {
            Expression expression = this;
            if (expression instanceof DefaultAliasedExpression) {
                DefaultAliasedExpression de = (DefaultAliasedExpression)expression;
                return new DefaultAliasedExpression(de.delegate, alias);
            }
            return new DefaultAliasedExpression(this, alias);
        }
    }

    record FunctionExpression(String function, List<Expression> arguments) implements Expression
    {
        @Override
        public String render(RenderContext context) {
            StringBuilder builder = new StringBuilder();
            for (Expression argument : this.arguments) {
                if (!builder.isEmpty()) {
                    builder.append(", ");
                }
                builder.append(argument.render(context));
            }
            return "%s(%s)".formatted(this.function, builder);
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record InPredicate(Expression path, String operator, Expression predicate) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            Expression predicate = this.predicate;
            String rendered = predicate.render(context);
            return (InPredicate.hasParenthesis(rendered) || predicate instanceof ParameterExpression ? "%s %s %s" : "%s %s (%s)").formatted(this.path.render(context), this.operator, rendered);
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }

        private static boolean hasParenthesis(String str) {
            return str.startsWith("(") && str.endsWith(")");
        }
    }

    public static final class Join
    implements Origin,
    Expression {
        private final Origin source;
        private final String joinType;
        private final String path;

        Join(Origin source, String joinType, String path) {
            this.source = source;
            this.joinType = joinType;
            this.path = path;
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Override
        public String getPath() {
            return this.source.getPath() + "." + this.getName();
        }

        @Override
        public String render(RenderContext context) {
            return "%s %s %s".formatted(this.joinType, context.getAlias(this.source), this.path);
        }

        public Origin source() {
            return this.source;
        }

        public String joinType() {
            return this.joinType;
        }

        public String path() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Join that = (Join)obj;
            return Objects.equals(this.source, that.source) && Objects.equals(this.joinType, that.joinType) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.joinType, this.path);
        }

        public String toString() {
            return "Join[source=" + String.valueOf(this.source) + ", joinType=" + this.joinType + ", path=" + this.path + "]";
        }
    }

    record LhsPredicate(Expression path, String predicate) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "%s %s".formatted(this.path.render(context), this.predicate);
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record LikePredicate(Expression left, String operator, Expression right, String escape) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "%s %s %s ESCAPE '%s'".formatted(this.left.render(context), this.operator, this.right.render(context), this.escape);
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record LiteralExpression(String expression) implements Expression
    {
        @Override
        public String render(RenderContext context) {
            return this.expression;
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record Multiselect(Origin source, Collection<? extends Expression> paths) implements Selection
    {
        @Override
        public String render(RenderContext context) {
            StringBuilder builder = new StringBuilder();
            for (Expression expression : this.paths) {
                if (!builder.isEmpty()) {
                    builder.append(", ");
                }
                builder.append(expression.render(context));
                if (context.isConstructorContext() || !(expression instanceof AliasedExpression)) continue;
                AliasedExpression ae = (AliasedExpression)expression;
                builder.append(" AS ").append(ae.getAlias());
            }
            return builder.toString();
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record NestedPredicate(Predicate delegate) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "(%s)".formatted(this.delegate.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record OperatorPredicate(Expression path, String operator, Expression predicate) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "%s %s %s".formatted(this.path.render(context), this.operator, this.predicate.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record OrPredicate(Predicate left, Predicate right) implements Predicate
    {
        @Override
        public String render(RenderContext context) {
            return "%s OR %s".formatted(this.left.render(context), this.right.render(context));
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    record OrderExpression(Expression sortExpression, @org.springframework.lang.Nullable Sort.Direction direction, Sort.NullHandling nullHandling) implements Expression
    {
        @Override
        public String render(RenderContext context) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.sortExpression.render(context));
            if (this.direction != null) {
                builder.append(" ");
                builder.append(this.direction.isDescending() ? QueryTokens.TOKEN_DESC : QueryTokens.TOKEN_ASC);
                if (this.nullHandling == Sort.NullHandling.NULLS_FIRST) {
                    builder.append(" NULLS FIRST");
                } else if (this.nullHandling == Sort.NullHandling.NULLS_LAST) {
                    builder.append(" NULLS LAST");
                }
            }
            return builder.toString();
        }
    }

    public static interface Origin {
        public String getName();

        public String getPath();
    }

    record ParameterExpression(ParameterPlaceholder parameter) implements Expression
    {
        @Override
        public String render(RenderContext context) {
            return this.parameter.placeholder;
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    public record ParameterPlaceholder(String placeholder) {
        public ParameterPlaceholder {
            Assert.hasText((String)placeholder, (String)"Placeholder must not be null nor empty");
        }

        public static ParameterPlaceholder indexed(int index) {
            return new ParameterPlaceholder("?%s".formatted(index));
        }

        public static ParameterPlaceholder named(String name) {
            Assert.hasText((String)name, (String)"Placeholder name must not be empty");
            return new ParameterPlaceholder(":%s".formatted(name));
        }
    }

    record PathAndOrigin(PropertyPath path, Origin origin, boolean onTheJoin) implements PathExpression
    {
        @Override
        public PropertyPath getPropertyPath() {
            return this.path;
        }

        @Override
        public String render(RenderContext context) {
            if (this.path().hasNext() || !this.onTheJoin()) {
                return context.prefixWithAlias(this.origin(), this.path().toDotPath());
            }
            return context.getAlias(this.origin());
        }

        public Expression parent() {
            Origin origin = this.origin;
            if (origin instanceof Join) {
                Join join = (Join)origin;
                return new PathAndOrigin(this.path(), join.source(), false);
            }
            throw new IllegalStateException("Cannot obtain parent expression for non-join origin: " + String.valueOf(this.origin));
        }
    }

    public static interface PathExpression
    extends Expression {
        public PropertyPath getPropertyPath();
    }

    public static interface Predicate
    extends Renderable {
        @Contract(value="_ -> new")
        @CheckReturnValue
        default public Predicate or(Predicate other) {
            return new OrPredicate(this, other);
        }

        @Contract(value="_ -> new")
        @CheckReturnValue
        default public Predicate and(Predicate other) {
            return new AndPredicate(this, other);
        }

        @Contract(value="-> new")
        @CheckReturnValue
        default public Predicate nest() {
            return new NestedPredicate(this);
        }
    }

    public static class RenderContext {
        public static final RenderContext EMPTY = new RenderContext(Collections.emptyMap()){

            @Override
            public String getAlias(Origin source) {
                return "";
            }
        };
        private final Map<Origin, String> aliases;
        private int counter;

        RenderContext(Map<Origin, String> aliases) {
            this.aliases = aliases;
        }

        public String getAlias(Origin source) {
            return this.aliases.computeIfAbsent(source, it -> JpqlQueryBuilder.getAlias(source.getName(), s -> !this.aliases.containsValue(s), () -> "join_" + this.counter++));
        }

        public String prefixWithAlias(Origin source, String fragment) {
            String alias = this.getAlias(source);
            return ObjectUtils.isEmpty((Object)source) ? fragment : alias + "." + fragment;
        }

        public boolean isConstructorContext() {
            return false;
        }
    }

    public static interface Renderable {
        public String render(RenderContext var1);
    }

    public static class Select
    extends AbstractJpqlQuery {
        private final Selection selection;
        private final Entity entity;
        private final Map<String, Join> joins = new LinkedHashMap<String, Join>();
        private final List<Expression> orderBy = new ArrayList<Expression>();

        private Select(Selection selection, Entity entity) {
            this.selection = selection;
            this.entity = entity;
        }

        @Contract(value="_ -> this")
        public Select join(Join join) {
            Origin origin = join.source();
            if (origin instanceof Join) {
                Join parent = (Join)origin;
                this.join(parent);
            }
            this.joins.put(join.joinType() + "_" + join.getPath(), join);
            return this;
        }

        @Contract(value="_ -> this")
        public Select orderBy(Expression orderBy) {
            this.orderBy.add(orderBy);
            return this;
        }

        @Override
        String render() {
            LinkedHashMap<Origin, String> aliases = new LinkedHashMap<Origin, String>();
            aliases.put(this.entity, this.entity.alias);
            RenderContext renderContext = new RenderContext(aliases);
            StringBuilder where = new StringBuilder();
            StringBuilder orderby = new StringBuilder();
            StringBuilder result = new StringBuilder("SELECT %s FROM %s %s".formatted(this.selection.render(renderContext), this.entity.getName(), this.entity.getAlias()));
            if (this.getWhere() != null) {
                where.append(" WHERE ").append(this.getWhere().render(renderContext));
            }
            if (!this.orderBy.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Expression order : this.orderBy) {
                    if (!builder.isEmpty()) {
                        builder.append(", ");
                    }
                    builder.append(order.render(renderContext));
                }
                orderby.append(" ORDER BY ").append((CharSequence)builder);
            }
            aliases.keySet().forEach(key -> {
                if (key instanceof Join) {
                    Join js = (Join)key;
                    this.join(js);
                }
            });
            for (Join join : this.joins.values()) {
                result.append(" ").append(join.joinType()).append(" ").append(renderContext.getAlias(join.source())).append(".").append(join.path()).append(" ").append(renderContext.getAlias(join));
            }
            result.append((CharSequence)where).append((CharSequence)orderby);
            return result.toString();
        }
    }

    public static interface SelectStep {
        @CheckReturnValue
        public SelectStep distinct();

        @CheckReturnValue
        public Select entity();

        @CheckReturnValue
        public Select count();

        @CheckReturnValue
        default public Select instantiate(Class<?> resultType, Collection<? extends Expression> paths) {
            return this.instantiate(resultType.getName(), paths);
        }

        @CheckReturnValue
        public Select instantiate(String var1, Collection<? extends Expression> var2);

        @CheckReturnValue
        public Select select(Collection<? extends Expression> var1);

        @CheckReturnValue
        default public Select select(PathExpression path) {
            return this.select(List.of(path));
        }

        @CheckReturnValue
        public Select select(Selection var1);
    }

    public static interface Selection {
        public String render(RenderContext var1);
    }

    record StringLiteralExpression(String literal) implements Expression
    {
        @Override
        public String render(RenderContext context) {
            return "'%s'".formatted(this.literal.replaceAll("'", "''"));
        }

        public String raw() {
            return this.literal;
        }

        @Override
        public String toString() {
            return this.render(RenderContext.EMPTY);
        }
    }

    public static interface WhereStep {
        public Predicate between(Expression var1, Expression var2);

        public Predicate gt(Expression var1);

        public Predicate gte(Expression var1);

        public Predicate lt(Expression var1);

        public Predicate lte(Expression var1);

        public Predicate isNull();

        public Predicate isNotNull();

        public Predicate isTrue();

        public Predicate isFalse();

        public Predicate isEmpty();

        public Predicate isNotEmpty();

        public Predicate in(Expression var1);

        public Predicate notIn(Expression var1);

        public Predicate memberOf(Expression var1);

        public Predicate notMemberOf(Expression var1);

        default public Predicate like(String value, String escape) {
            return this.like(JpqlQueryBuilder.expression(value), escape);
        }

        public Predicate like(Expression var1, String var2);

        public Predicate notLike(Expression var1, String var2);

        public Predicate eq(Expression var1);

        public Predicate neq(Expression var1);
    }
}

