/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionBase;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.ScrollDelegate;
import org.springframework.data.jpa.repository.support.EntityGraphFactory;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.jpa.repository.support.JakartaTuple;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class FetchableFluentQueryByPredicate<S, R>
extends FluentQuerySupport<S, R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final EntityPath<?> entityPath;
    private final JpaEntityInformation<S, ?> entityInformation;
    private final FluentQuerySupport.ScrollQueryFactory<AbstractJPAQuery<?, ?>> scrollQueryFactory;
    private final Predicate predicate;
    private final Function<Sort, AbstractJPAQuery<?, ?>> finder;
    private final BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder;
    private final Function<Predicate, Long> countOperation;
    private final Function<Predicate, Boolean> existsOperation;
    private final EntityManager entityManager;

    FetchableFluentQueryByPredicate(EntityPath<?> entityPath, Predicate predicate, JpaEntityInformation<S, ?> entityInformation, Function<Sort, AbstractJPAQuery<?, ?>> finder, FluentQuerySupport.ScrollQueryFactory<AbstractJPAQuery<?, ?>> scrollQueryFactory, BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, EntityManager entityManager, ProjectionFactory projectionFactory) {
        this(entityPath, predicate, entityInformation, entityInformation.getJavaType(), Sort.unsorted(), 0, Collections.emptySet(), finder, scrollQueryFactory, pagedFinder, countOperation, existsOperation, entityManager, projectionFactory);
    }

    private FetchableFluentQueryByPredicate(EntityPath<?> entityPath, Predicate predicate, JpaEntityInformation<S, ?> entityInformation, Class<R> resultType, Sort sort, int limit, Collection<String> properties, Function<Sort, AbstractJPAQuery<?, ?>> finder, FluentQuerySupport.ScrollQueryFactory<AbstractJPAQuery<?, ?>> scrollQueryFactory, BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, EntityManager entityManager, ProjectionFactory projectionFactory) {
        super(resultType, sort, limit, properties, entityInformation.getJavaType(), projectionFactory);
        this.entityInformation = entityInformation;
        this.entityPath = entityPath;
        this.predicate = predicate;
        this.finder = finder;
        this.scrollQueryFactory = scrollQueryFactory;
        this.pagedFinder = pagedFinder;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
        this.entityManager = entityManager;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return new FetchableFluentQueryByPredicate<S, R>(this.entityPath, this.predicate, this.entityInformation, this.resultType, this.sort.and(sort), this.limit, this.properties, this.finder, this.scrollQueryFactory, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public FluentQuery.FetchableFluentQuery<R> limit(int limit) {
        Assert.isTrue((limit >= 0 ? 1 : 0) != 0, (String)"Limit must not be negative");
        return new FetchableFluentQueryByPredicate<S, R>(this.entityPath, this.predicate, this.entityInformation, this.resultType, this.sort, limit, this.properties, this.finder, this.scrollQueryFactory, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        Assert.notNull(resultType, (String)"Projection target type must not be null");
        return new FetchableFluentQueryByPredicate<S, NR>(this.entityPath, this.predicate, this.entityInformation, resultType, this.sort, this.limit, this.properties, this.finder, this.scrollQueryFactory, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByPredicate<S, R>(this.entityPath, this.predicate, this.entityInformation, this.resultType, this.sort, this.limit, this.mergeProperties(properties), this.finder, this.scrollQueryFactory, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public R oneValue() {
        List results = ((AbstractJPAQuery)this.createSortedAndProjectedQuery(this.sort).limit(2L)).fetch();
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public R firstValue() {
        List results = ((AbstractJPAQuery)this.createSortedAndProjectedQuery(this.sort).limit(1L)).fetch();
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public List<R> all() {
        return this.all(this.sort);
    }

    private List<R> all(Sort sort) {
        return this.convert(this.createSortedAndProjectedQuery(sort).fetch());
    }

    public Window<R> scroll(ScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"ScrollPosition must not be null");
        return new PredicateScrollDelegate<S>(this.scrollQueryFactory, this.entityInformation).scroll(this.returnedType, this.sort, this.limit, scrollPosition).map(this.getConversionFunction());
    }

    public Page<R> page(Pageable pageable) {
        return pageable.isUnpaged() ? new PageImpl(this.all(pageable.getSortOr(this.sort))) : this.readPage(pageable);
    }

    public Slice<R> slice(Pageable pageable) {
        return pageable.isUnpaged() ? new SliceImpl(this.all(pageable.getSortOr(this.sort))) : this.readSlice(pageable);
    }

    public Stream<R> stream() {
        return this.createSortedAndProjectedQuery(this.sort).stream().map(this.getConversionFunction());
    }

    public long count() {
        return this.countOperation.apply(this.predicate);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.predicate);
    }

    private AbstractJPAQuery<?, ?> createSortedAndProjectedQuery(Sort sort) {
        AbstractJPAQuery<?, ?> query = this.finder.apply(sort);
        this.applyQuerySettings(this.returnedType, this.limit, query, null);
        return query;
    }

    private void applyQuerySettings(ReturnedType returnedType, int limit, AbstractJPAQuery<?, ?> query, @Nullable ScrollPosition scrollPosition) {
        List inputProperties = returnedType.getInputProperties();
        if (returnedType.needsCustomConstruction()) {
            Collection<Object> requiredSelection = scrollPosition instanceof KeysetScrollPosition && returnedType.getReturnedType().isInterface() ? KeysetScrollDelegate.getProjectionInputProperties(this.entityInformation, inputProperties, this.sort) : inputProperties;
            PathBuilder builder = new PathBuilder(this.entityPath.getType(), this.entityPath.getMetadata());
            Expression[] projection = (Expression[])requiredSelection.stream().map(arg_0 -> ((PathBuilder)builder).get(arg_0)).toArray(Expression[]::new);
            if (returnedType.getReturnedType().isInterface()) {
                query.select((Expression)new JakartaTuple(projection));
            } else {
                query.select((Expression)new DtoProjection(returnedType.getReturnedType(), projection));
            }
        }
        if (!this.properties.isEmpty()) {
            query.setHint("jakarta.persistence.fetchgraph", EntityGraphFactory.create(this.entityManager, this.entityType, this.properties));
        }
        if (limit != 0) {
            query.limit((long)limit);
        }
    }

    private Page<R> readPage(Pageable pageable) {
        Sort sort = pageable.getSortOr(this.sort);
        AbstractJPAQuery<?, ?> query = this.createQuery(pageable, sort);
        List<R> paginatedResults = this.convert(query.fetch());
        return PageableExecutionUtils.getPage(paginatedResults, (Pageable)this.withSort(pageable, sort), () -> this.countOperation.apply(this.predicate));
    }

    private Slice<R> readSlice(Pageable pageable) {
        boolean hasNext;
        Sort sort = pageable.getSortOr(this.sort);
        AbstractJPAQuery<?, ?> query = this.createQuery(pageable, sort);
        query.limit((long)(pageable.getPageSize() + 1));
        List resultList = query.fetch();
        boolean bl = hasNext = resultList.size() > pageable.getPageSize();
        if (hasNext) {
            resultList = resultList.subList(0, pageable.getPageSize());
        }
        List<R> slice = this.convert(resultList);
        return new SliceImpl(slice, pageable, hasNext);
    }

    private AbstractJPAQuery<?, ?> createQuery(Pageable pageable, Sort sort) {
        AbstractJPAQuery<?, ?> query = this.pagedFinder.apply(sort, pageable);
        if (!this.properties.isEmpty()) {
            query.setHint("jakarta.persistence.fetchgraph", EntityGraphFactory.create(this.entityManager, this.entityType, this.properties));
        }
        return query;
    }

    private List<R> convert(List<?> resultList) {
        Function<Object, R> conversionFunction = this.getConversionFunction();
        ArrayList<R> mapped = new ArrayList<R>(resultList.size());
        for (Object o : resultList) {
            mapped.add(conversionFunction.apply(o));
        }
        return mapped;
    }

    private Function<Object, R> getConversionFunction() {
        return this.getConversionFunction(this.entityType, this.resultType);
    }

    private static class DtoProjection
    extends ExpressionBase<Object> {
        private final Expression<?>[] projection;

        public DtoProjection(Class<?> resultType, Expression<?>[] projection) {
            super(resultType);
            this.projection = projection;
        }

        public <R, C> R accept(Visitor<R, C> v, @Nullable C context) {
            if (v instanceof JPQLSerializer) {
                JPQLSerializer s = (JPQLSerializer)v;
                ((JPQLSerializer)((JPQLSerializer)s.append("new ")).append(this.getType().getName())).append("(");
                boolean first = true;
                Expression<?>[] expressionArray = this.projection;
                int n = this.projection.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression<?> expression = expressionArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        s.append(", ");
                    }
                    expression.accept(v, context);
                    ++n2;
                }
                s.append(")");
            }
            return (R)((Object)this);
        }
    }

    class PredicateScrollDelegate<T>
    extends ScrollDelegate<T> {
        private final FluentQuerySupport.ScrollQueryFactory<AbstractJPAQuery<?, ?>> scrollFunction;

        PredicateScrollDelegate(FluentQuerySupport.ScrollQueryFactory<AbstractJPAQuery<?, ?>> scrollQueryFactory, JpaEntityInformation<T, ?> entity) {
            super(entity);
            this.scrollFunction = scrollQueryFactory;
        }

        public Window<T> scroll(ReturnedType returnedType, Sort sort, int limit, ScrollPosition scrollPosition) {
            AbstractJPAQuery<?, ?> query = this.scrollFunction.createQuery(FetchableFluentQueryByPredicate.this, scrollPosition);
            FetchableFluentQueryByPredicate.this.applyQuerySettings(returnedType, limit, query, scrollPosition);
            return this.scroll(query.createQuery(), sort, scrollPosition);
        }
    }
}

