/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryRenderer;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.data.jpa.repository.query.JpaQueryTransformerSupport;
import org.springframework.data.jpa.repository.query.QueryTransformers;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class HqlQueryTransformer
extends HqlQueryRenderer {
    private final Sort sort;
    private final boolean countQuery;
    @Nullable
    private final String countProjection;
    @Nullable
    private String primaryFromAlias = null;
    private List<JpaQueryParsingToken> projection = Collections.emptyList();
    private boolean projectionProcessed;
    private boolean hasConstructorExpression = false;
    private JpaQueryTransformerSupport transformerSupport;

    HqlQueryTransformer() {
        this(Sort.unsorted(), false, null);
    }

    HqlQueryTransformer(Sort sort) {
        this(sort, false, null);
    }

    HqlQueryTransformer(boolean countQuery, @Nullable String countProjection) {
        this(Sort.unsorted(), countQuery, countProjection);
    }

    private HqlQueryTransformer(Sort sort, boolean countQuery, @Nullable String countProjection) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        this.sort = sort;
        this.countQuery = countQuery;
        this.countProjection = countProjection;
        this.transformerSupport = new JpaQueryTransformerSupport();
    }

    @Nullable
    public String getAlias() {
        return this.primaryFromAlias;
    }

    public List<JpaQueryParsingToken> getProjection() {
        return this.projection;
    }

    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    private static boolean isSubquery(ParserRuleContext ctx) {
        if (ctx instanceof HqlParser.SubqueryContext) {
            return true;
        }
        if (ctx instanceof HqlParser.SelectStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.InsertStatementContext) {
            return false;
        }
        return HqlQueryTransformer.isSubquery(ctx.getParent());
    }

    @Override
    public List<JpaQueryParsingToken> visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = HqlQueryTransformer.newArrayList();
        if (ctx.query() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.queryExpression()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        if (!this.countQuery && !HqlQueryTransformer.isSubquery(ctx)) {
            if (ctx.queryOrder() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.queryOrder()));
            }
            if (this.sort.isSorted()) {
                if (ctx.queryOrder() != null) {
                    JpaQueryParsingToken.NOSPACE(tokens);
                    tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
                } else {
                    JpaQueryParsingToken.SPACE(tokens);
                    tokens.add(JpaQueryParsingToken.TOKEN_ORDER_BY);
                }
                tokens.addAll(this.transformerSupport.generateOrderByArguments(this.primaryFromAlias, this.sort));
            }
        } else if (ctx.queryOrder() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.queryOrder()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFromQuery(HqlParser.FromQueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = HqlQueryTransformer.newArrayList();
        if (this.countQuery && !HqlQueryTransformer.isSubquery(ctx) && ctx.selectClause() == null) {
            tokens.add(JpaQueryParsingToken.TOKEN_SELECT_COUNT);
            if (this.countProjection != null) {
                tokens.add(new JpaQueryParsingToken(this.countProjection));
            } else {
                tokens.add(new JpaQueryParsingToken(() -> this.primaryFromAlias, false));
            }
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        if (ctx.fromClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.havingClause()));
        }
        if (ctx.selectClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.selectClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitQueryOrder(HqlParser.QueryOrderContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = HqlQueryTransformer.newArrayList();
        if (!this.countQuery) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (ctx.limitClause() != null) {
            JpaQueryParsingToken.SPACE(tokens);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.limitClause()));
        }
        if (ctx.offsetClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.offsetClause()));
        }
        if (ctx.fetchClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.fetchClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFromRoot(HqlParser.FromRootContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = HqlQueryTransformer.newArrayList();
        if (ctx.entityName() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entityName()));
            if (ctx.variable() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
                if (this.primaryFromAlias == null && !HqlQueryTransformer.isSubquery(ctx)) {
                    this.primaryFromAlias = ((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken();
                }
            } else if (this.countQuery) {
                tokens.add(JpaQueryParsingToken.TOKEN_AS);
                tokens.add(JpaQueryParsingToken.TOKEN_DOUBLE_UNDERSCORE);
                if (this.primaryFromAlias == null && !HqlQueryTransformer.isSubquery(ctx)) {
                    this.primaryFromAlias = JpaQueryParsingToken.TOKEN_DOUBLE_UNDERSCORE.getToken();
                }
            }
        } else if (ctx.subquery() != null) {
            if (ctx.LATERAL() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.LATERAL()));
            }
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
            if (ctx.variable() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
                if (this.primaryFromAlias == null && !HqlQueryTransformer.isSubquery(ctx)) {
                    this.primaryFromAlias = ((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken();
                }
            }
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin(HqlParser.JoinContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.joinType()));
        tokens.add(new JpaQueryParsingToken(ctx.JOIN()));
        if (!this.countQuery && ctx.FETCH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FETCH()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.joinTarget()));
        if (ctx.joinRestriction() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.joinRestriction()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinPath(HqlParser.JoinPathContext ctx) {
        Object tokens = super.visitJoinPath(ctx);
        if (ctx.variable() != null) {
            this.transformerSupport.registerAlias(((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken());
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinSubquery(HqlParser.JoinSubqueryContext ctx) {
        Object tokens = super.visitJoinSubquery(ctx);
        if (ctx.variable() != null) {
            this.transformerSupport.registerAlias(((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken());
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAlias(HqlParser.AliasContext ctx) {
        Object tokens = super.visitAlias(ctx);
        if (this.primaryFromAlias == null && !HqlQueryTransformer.isSubquery(ctx)) {
            this.primaryFromAlias = ((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken();
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitVariable(HqlParser.VariableContext ctx) {
        Object tokens = super.visitVariable(ctx);
        if (ctx.identifier() != null) {
            this.transformerSupport.registerAlias(((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken());
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelectClause(HqlParser.SelectClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = HqlQueryTransformer.newArrayList();
        tokens.add(new JpaQueryParsingToken(ctx.SELECT()));
        if (this.countQuery && !HqlQueryTransformer.isSubquery(ctx)) {
            tokens.add(JpaQueryParsingToken.TOKEN_COUNT_FUNC);
            if (this.countProjection != null) {
                tokens.add(new JpaQueryParsingToken(this.countProjection));
            }
        }
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
        }
        List selectionListTokens = (List)this.visit((ParseTree)ctx.selectionList());
        if (this.countQuery && !HqlQueryTransformer.isSubquery(ctx)) {
            if (this.countProjection == null) {
                if (ctx.DISTINCT() != null) {
                    List<JpaQueryParsingToken> countSelection = QueryTransformers.filterCountSelection(selectionListTokens);
                    if (countSelection.stream().anyMatch(hqlToken -> hqlToken.getToken().contains("new"))) {
                        tokens.add(new JpaQueryParsingToken(() -> this.primaryFromAlias));
                    } else {
                        tokens.addAll(countSelection);
                    }
                } else {
                    tokens.add(new JpaQueryParsingToken(() -> this.primaryFromAlias));
                }
            }
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else {
            tokens.addAll(selectionListTokens);
        }
        if (!this.projectionProcessed && !HqlQueryTransformer.isSubquery(ctx)) {
            this.projection = selectionListTokens;
            this.projectionProcessed = true;
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInstantiation(HqlParser.InstantiationContext ctx) {
        this.hasConstructorExpression = true;
        return super.visitInstantiation(ctx);
    }

    static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }
}

