/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class ParameterMetadataProvider {
    private final CriteriaBuilder builder;
    private final Iterator<? extends Parameter> parameters;
    private final List<ParameterMetadata<?>> expressions;
    @Nullable
    private final Iterator<Object> bindableParameterValues;
    private final EscapeCharacter escape;

    public ParameterMetadataProvider(CriteriaBuilder builder, ParametersParameterAccessor accessor, EscapeCharacter escape) {
        this(builder, (Iterator<Object>)accessor.iterator(), accessor.getParameters(), escape);
    }

    public ParameterMetadataProvider(CriteriaBuilder builder, Parameters<?, ?> parameters, EscapeCharacter escape) {
        this(builder, null, parameters, escape);
    }

    private ParameterMetadataProvider(CriteriaBuilder builder, @Nullable Iterator<Object> bindableParameterValues, Parameters<?, ?> parameters, EscapeCharacter escape) {
        Assert.notNull((Object)builder, (String)"CriteriaBuilder must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull((Object)escape, (String)"EscapeCharacter must not be null!");
        this.builder = builder;
        this.parameters = parameters.getBindableParameters().iterator();
        this.expressions = new ArrayList();
        this.bindableParameterValues = bindableParameterValues;
        this.escape = escape;
    }

    public List<ParameterMetadata<?>> getExpressions() {
        return this.expressions;
    }

    public <T> ParameterMetadata<T> next(Part part) {
        Assert.isTrue((boolean)this.parameters.hasNext(), () -> String.format("No parameter available for part %s.", part));
        Parameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter);
    }

    public <T> ParameterMetadata<? extends T> next(Part part, Class<T> type) {
        Parameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, parameter);
    }

    private <T> ParameterMetadata<T> next(Part part, Class<T> type, Parameter parameter) {
        Assert.notNull(type, (String)"Type must not be null!");
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        Supplier<String> name = () -> (String)parameter.getName().orElseThrow(() -> new IllegalArgumentException("o_O Parameter needs to be named"));
        ParameterExpression expression = parameter.isExplicitlyNamed() ? this.builder.parameter(reifiedType, name.get()) : this.builder.parameter(reifiedType);
        Object value = this.bindableParameterValues == null ? ParameterMetadata.PLACEHOLDER : this.bindableParameterValues.next();
        ParameterMetadata metadata = new ParameterMetadata(expression, part, value, this.escape);
        this.expressions.add(metadata);
        return metadata;
    }

    EscapeCharacter getEscape() {
        return this.escape;
    }

    static class ParameterMetadata<T> {
        static final Object PLACEHOLDER = new Object();
        private final Part.Type type;
        private final ParameterExpression<T> expression;
        private final EscapeCharacter escape;
        private final boolean ignoreCase;

        public ParameterMetadata(ParameterExpression<T> expression, Part part, @Nullable Object value, EscapeCharacter escape) {
            this.expression = expression;
            this.type = value == null && Part.Type.SIMPLE_PROPERTY.equals((Object)part.getType()) ? Part.Type.IS_NULL : part.getType();
            this.ignoreCase = Part.IgnoreCaseType.ALWAYS.equals((Object)part.shouldIgnoreCase());
            this.escape = escape;
        }

        public ParameterExpression<T> getExpression() {
            return this.expression;
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        @Nullable
        public Object prepare(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            Class expressionType = this.expression.getJavaType();
            if (String.class.equals((Object)expressionType)) {
                switch (this.type) {
                    case STARTING_WITH: {
                        return String.format("%s%%", this.escape.escape(PersistenceProvider.condense(value).toString()));
                    }
                    case ENDING_WITH: {
                        return String.format("%%%s", this.escape.escape(PersistenceProvider.condense(value).toString()));
                    }
                    case CONTAINING: 
                    case NOT_CONTAINING: {
                        return String.format("%%%s%%", this.escape.escape(PersistenceProvider.condense(value).toString()));
                    }
                }
                return PersistenceProvider.condense(value);
            }
            return Collection.class.isAssignableFrom(expressionType) ? ParameterMetadata.upperIfIgnoreCase(this.ignoreCase, ParameterMetadata.toCollection(value)) : value;
        }

        @Nullable
        private static Collection<?> toCollection(@Nullable Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.isEmpty() ? null : collection;
            }
            if (ObjectUtils.isArray((Object)value)) {
                List<Object> collection = Arrays.asList(ObjectUtils.toObjectArray((Object)value));
                return collection.isEmpty() ? null : collection;
            }
            return Collections.singleton(value);
        }

        @Nullable
        private static Collection<?> upperIfIgnoreCase(boolean ignoreCase, @Nullable Collection<?> collection) {
            if (!ignoreCase || CollectionUtils.isEmpty(collection)) {
                return collection;
            }
            return collection.stream().map(it -> it == null ? null : it.toUpperCase()).collect(Collectors.toList());
        }
    }
}

