/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public abstract class AbstractDelegatingRowMapper<T>
implements RowMapper<T> {
    private final RowMapper<T> delegate;

    protected AbstractDelegatingRowMapper(RowMapper<T> delegate) {
        Assert.notNull(delegate, (String)"Delegating RowMapper cannot be null");
        this.delegate = delegate;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object intermediate = this.delegate.mapRow(rs, rowNum);
        return (T)this.postProcessMapping(intermediate);
    }

    protected T postProcessMapping(T object) {
        return object;
    }
}

