/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.elasticsearch.client.reactive.WebClientProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

class DefaultWebClientProvider
implements WebClientProvider {
    private final Map<InetSocketAddress, WebClient> cachedClients;
    private final String scheme;
    @Nullable
    private final ClientHttpConnector connector;
    private final Consumer<Throwable> errorListener;
    private final HttpHeaders headers;
    @Nullable
    private final String pathPrefix;
    private final Function<WebClient, WebClient> webClientConfigurer;
    private final Consumer<WebClient.RequestHeadersSpec<?>> requestConfigurer;

    DefaultWebClientProvider(String scheme, @Nullable ClientHttpConnector connector) {
        this(scheme, connector, e -> {}, HttpHeaders.EMPTY, null, Function.identity(), requestHeadersSpec -> {});
    }

    private DefaultWebClientProvider(String scheme, @Nullable ClientHttpConnector connector, Consumer<Throwable> errorListener, HttpHeaders headers, @Nullable String pathPrefix, Function<WebClient, WebClient> webClientConfigurer, Consumer<WebClient.RequestHeadersSpec<?>> requestConfigurer) {
        Assert.notNull((Object)scheme, (String)"Scheme must not be null! A common scheme would be 'http'.");
        Assert.notNull(errorListener, (String)"errorListener must not be null! You may want use a no-op one 'e -> {}' instead.");
        Assert.notNull((Object)headers, (String)"headers must not be null! Think about using 'HttpHeaders.EMPTY' as an alternative.");
        Assert.notNull(webClientConfigurer, (String)"webClientConfigurer must not be null! You may want use a no-op one 'Function.identity()' instead.");
        Assert.notNull(requestConfigurer, (String)"requestConfigurer must not be null! You may want use a no-op one 'r -> {}' instead.\"");
        this.cachedClients = new ConcurrentHashMap<InetSocketAddress, WebClient>();
        this.scheme = scheme;
        this.connector = connector;
        this.errorListener = errorListener;
        this.headers = headers;
        this.pathPrefix = pathPrefix;
        this.webClientConfigurer = webClientConfigurer;
        this.requestConfigurer = requestConfigurer;
    }

    @Override
    public WebClient get(InetSocketAddress endpoint) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be empty!");
        return this.cachedClients.computeIfAbsent(endpoint, this::createWebClientForSocketAddress);
    }

    @Override
    public HttpHeaders getDefaultHeaders() {
        return this.headers;
    }

    @Override
    public Consumer<Throwable> getErrorListener() {
        return this.errorListener;
    }

    @Override
    @Nullable
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public WebClientProvider withDefaultHeaders(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null.");
        HttpHeaders merged = new HttpHeaders();
        merged.addAll((MultiValueMap)this.headers);
        merged.addAll((MultiValueMap)headers);
        return new DefaultWebClientProvider(this.scheme, this.connector, this.errorListener, merged, this.pathPrefix, this.webClientConfigurer, this.requestConfigurer);
    }

    @Override
    public WebClientProvider withRequestConfigurer(Consumer<WebClient.RequestHeadersSpec<?>> requestConfigurer) {
        Assert.notNull(requestConfigurer, (String)"requestConfigurer must not be null.");
        return new DefaultWebClientProvider(this.scheme, this.connector, this.errorListener, this.headers, this.pathPrefix, this.webClientConfigurer, requestConfigurer);
    }

    @Override
    public WebClientProvider withErrorListener(Consumer<Throwable> errorListener) {
        Assert.notNull(errorListener, (String)"Error listener must not be null.");
        Consumer<Throwable> listener = this.errorListener.andThen(errorListener);
        return new DefaultWebClientProvider(this.scheme, this.connector, listener, this.headers, this.pathPrefix, this.webClientConfigurer, this.requestConfigurer);
    }

    @Override
    public WebClientProvider withPathPrefix(String pathPrefix) {
        Assert.notNull((Object)pathPrefix, (String)"pathPrefix must not be null.");
        return new DefaultWebClientProvider(this.scheme, this.connector, this.errorListener, this.headers, pathPrefix, this.webClientConfigurer, this.requestConfigurer);
    }

    @Override
    public WebClientProvider withWebClientConfigurer(Function<WebClient, WebClient> webClientConfigurer) {
        return new DefaultWebClientProvider(this.scheme, this.connector, this.errorListener, this.headers, this.pathPrefix, webClientConfigurer, this.requestConfigurer);
    }

    protected WebClient createWebClientForSocketAddress(InetSocketAddress socketAddress) {
        WebClient.Builder builder = WebClient.builder().defaultHeaders(it -> it.addAll((MultiValueMap)this.getDefaultHeaders())).defaultRequest(this.requestConfigurer);
        if (this.connector != null) {
            builder = builder.clientConnector(this.connector);
        }
        String baseUrl = String.format("%s://%s:%d%s", this.scheme, socketAddress.getHostString(), socketAddress.getPort(), this.pathPrefix == null ? "" : '/' + this.pathPrefix);
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory(baseUrl);
        uriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        builder.uriBuilderFactory((UriBuilderFactory)uriBuilderFactory);
        WebClient webClient = builder.filter((request, next) -> next.exchange(request).doOnError(this.errorListener)).build();
        return this.webClientConfigurer.apply(webClient);
    }
}

