/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.Suggester;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.lang.Nullable;

public class NativeQuery
extends BaseQuery {
    @Nullable
    private final Query query;
    @Nullable
    private Query filter;
    private final Map<String, Aggregation> aggregations = new LinkedHashMap<String, Aggregation>();
    @Nullable
    private Suggester suggester;
    @Nullable
    private FieldCollapse fieldCollapse;
    private List<ScriptedField> scriptedFields = Collections.emptyList();
    private List<RescorerQuery> rescorerQueries = Collections.emptyList();

    public NativeQuery(NativeQueryBuilder builder) {
        super(builder);
        this.query = builder.getQuery();
        this.filter = builder.getFilter();
        this.aggregations.putAll(builder.getAggregations());
        this.suggester = builder.getSuggester();
        this.fieldCollapse = builder.getFieldCollapse();
        this.scriptedFields = builder.getScriptedFields();
        this.rescorerQueries = builder.getRescorerQueries();
    }

    public NativeQuery(@Nullable Query query) {
        this.query = query;
    }

    public static NativeQueryBuilder builder() {
        return new NativeQueryBuilder();
    }

    @Nullable
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Query getFilter() {
        return this.filter;
    }

    public Map<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggester getSuggester() {
        return this.suggester;
    }

    @Nullable
    public FieldCollapse getFieldCollapse() {
        return this.fieldCollapse;
    }

    public List<ScriptedField> getScriptedFields() {
        return this.scriptedFields;
    }

    @Override
    public List<RescorerQuery> getRescorerQueries() {
        return this.rescorerQueries;
    }
}

