/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.repository.config.PropertiesBasedNamedQueriesFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NamedQueriesBeanDefinitionBuilder {
    private final String defaultLocation;
    private @Nullable String locations;

    public NamedQueriesBeanDefinitionBuilder(String defaultLocation) {
        Assert.hasText((String)defaultLocation, (String)"DefaultLocation must not be null nor empty");
        this.defaultLocation = defaultLocation;
    }

    public void setLocations(String locations) {
        Assert.hasText((String)locations, (String)"Locations must not be null nor empty");
        this.locations = locations;
    }

    public BeanDefinition build(@Nullable Object source) {
        BeanDefinitionBuilder namedQueries = BeanDefinitionBuilder.rootBeanDefinition(PropertiesBasedNamedQueriesFactoryBean.class);
        String locationsToUse = StringUtils.hasText((String)this.locations) ? this.locations : this.defaultLocation;
        namedQueries.addPropertyValue("locations", (Object)locationsToUse);
        if (!StringUtils.hasText((String)this.locations)) {
            namedQueries.addPropertyValue("ignoreResourceNotFound", (Object)true);
        }
        AbstractBeanDefinition namedQueriesDefinition = namedQueries.getBeanDefinition();
        namedQueriesDefinition.setSource(source);
        return namedQueriesDefinition;
    }
}

