/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import tools.jackson.databind.ObjectMapper;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
class ContentTypeConfiguration {
    ContentTypeConfiguration() {
    }

    @Bean(name={"integrationArgumentResolverMessageConverter"})
    public CompositeMessageConverter configurableCompositeMessageConverter(ObjectProvider<ObjectMapper> objectMapperObjectProvider, List<MessageConverter> customMessageConverters, @Nullable JsonMapper jsonMapper) {
        customMessageConverters = customMessageConverters.stream().filter(c -> this.isConverterEligible(c)).collect(Collectors.toList());
        CompositeMessageConverterFactory factory = new CompositeMessageConverterFactory(customMessageConverters, jsonMapper);
        return factory.getMessageConverterForAllRegistered();
    }

    private boolean isConverterEligible(Object messageConverter) {
        String messageConverterName = messageConverter.getClass().getName();
        if (messageConverterName.startsWith("org.springframework.cloud.")) {
            return true;
        }
        return !messageConverterName.startsWith("org.springframework.");
    }
}

