/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

class RoutingFunctionEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    RoutingFunctionEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String name = environment.getProperty("spring.cloud.function.definition");
        if (StringUtils.hasText((String)name) && (name.equals("functionRouter") || name.contains("functionRouter|") || name.contains("|functionRouter"))) {
            ((StandardEnvironment)environment).getSystemProperties().putIfAbsent("spring.cloud.function.routing.enabled", "true");
        }
        ((StandardEnvironment)environment).getSystemProperties().putIfAbsent("spring.cloud.function.configuration.default.copy-input-headers", "true");
    }
}

