/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.sleuth.instrument.web.mvc.TraceContextListenableFuture;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class TracingAsyncClientHttpRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler handler;

    public static AsyncClientHttpRequestInterceptor create(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
        return new TracingAsyncClientHttpRequestInterceptor(currentTraceContext, httpClientHandler);
    }

    @Autowired
    TracingAsyncClientHttpRequestInterceptor(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
        this.currentTraceContext = currentTraceContext;
        this.handler = httpClientHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest req, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        TracingClientHttpRequestInterceptor.HttpRequestWrapper request = new TracingClientHttpRequestInterceptor.HttpRequestWrapper(req);
        Span span = this.handler.handleSend((HttpClientRequest)request);
        String parentId = span.context().parentId();
        TraceContext invocationContext = parentId != null ? this.currentTraceContext.context() : null;
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());){
            TraceContextListenableFuture result = execution.executeAsync(req, body);
            result.addCallback(new TraceListenableFutureCallback(request, span, this.handler));
            TraceContextListenableFuture traceContextListenableFuture = invocationContext != null ? new TraceContextListenableFuture(result, this.currentTraceContext, invocationContext) : result;
            return traceContextListenableFuture;
        }
        catch (Throwable e) {
            this.handler.handleReceive((HttpClientResponse)new TracingClientHttpRequestInterceptor.ClientHttpResponseWrapper(request, null, e), span);
            throw e;
        }
    }

    static final class TraceListenableFutureCallback
    implements ListenableFutureCallback<ClientHttpResponse> {
        final TracingClientHttpRequestInterceptor.HttpRequestWrapper request;
        final Span span;
        final HttpClientHandler handler;

        TraceListenableFutureCallback(TracingClientHttpRequestInterceptor.HttpRequestWrapper request, Span span, HttpClientHandler handler) {
            this.request = request;
            this.span = span;
            this.handler = handler;
        }

        public void onFailure(Throwable ex) {
            this.handler.handleReceive((HttpClientResponse)new TracingClientHttpRequestInterceptor.ClientHttpResponseWrapper(this.request, null, ex), this.span);
        }

        public void onSuccess(ClientHttpResponse response) {
            this.handler.handleReceive((HttpClientResponse)new TracingClientHttpRequestInterceptor.ClientHttpResponseWrapper(this.request, response, null), this.span);
        }
    }
}

