/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class HttpClientBeanPostProcessor
implements BeanPostProcessor {
    final ConfigurableApplicationContext springContext;

    public HttpClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        LazyBean<CurrentTraceContext> currentContext = LazyBean.create(this.springContext, CurrentTraceContext.class);
        if (bean instanceof HttpClient) {
            TracingDoOnResponse doOnResponse = new TracingDoOnResponse(this.springContext);
            return ((HttpClient)bean).doOnResponseError((BiConsumer)new TracingDoOnErrorResponse(this.springContext)).doOnRedirect((BiConsumer)doOnResponse).doAfterResponseSuccess((BiConsumer)doOnResponse).doOnRequestError((BiConsumer)new TracingDoOnErrorRequest(this.springContext)).doOnRequest((BiConsumer)new TracingDoOnRequest(this.springContext)).mapConnect((Function)new TracingMapConnect(() -> {
                CurrentTraceContext ref = (CurrentTraceContext)currentContext.get();
                return ref != null ? ref.context() : null;
            }));
        }
        return bean;
    }

    static final class HttpClientResponseWrapper
    implements org.springframework.cloud.sleuth.http.HttpClientResponse {
        @Nullable
        final HttpClientResponse delegate;
        HttpClientRequestWrapper request;
        final Throwable error;

        HttpClientResponseWrapper(@Nullable HttpClientResponse delegate, Throwable error) {
            this.delegate = delegate;
            this.error = error;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate != null ? this.delegate.responseHeaders().names() : Collections.emptyList();
        }

        public HttpClientRequestWrapper request() {
            if (this.request == null && this.delegate instanceof reactor.netty.http.client.HttpClientRequest) {
                this.request = new HttpClientRequestWrapper((reactor.netty.http.client.HttpClientRequest)this.delegate, null);
            }
            return this.request;
        }

        public int statusCode() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.status().code();
        }

        public Throwable error() {
            return this.error;
        }

        public String header(String header) {
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.responseHeaders().get(header);
        }
    }

    static final class HttpClientRequestWrapper
    implements HttpClientRequest {
        final reactor.netty.http.client.HttpClientRequest delegate;
        final Connection connection;
        Boolean inetSocketAddress;
        InetSocketAddress address;

        HttpClientRequestWrapper(reactor.netty.http.client.HttpClientRequest delegate, Connection connection) {
            this.delegate = delegate;
            this.connection = connection;
        }

        InetSocketAddress address() {
            this.inetSocketAddress = this.inetSocketAddress != null ? this.inetSocketAddress : this.connection.address() instanceof InetSocketAddress;
            if (this.address != null && this.inetSocketAddress.booleanValue()) {
                return this.address;
            }
            if (this.address == null && this.inetSocketAddress.booleanValue()) {
                this.address = (InetSocketAddress)this.connection.address();
                this.inetSocketAddress = true;
                return this.address;
            }
            return null;
        }

        public Collection<String> headerNames() {
            return this.delegate.requestHeaders().names();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.fullPath();
        }

        public String url() {
            return this.delegate.resourceUrl();
        }

        public String header(String name) {
            return this.delegate.requestHeaders().get(name);
        }

        public void header(String name, String value) {
            this.delegate.header((CharSequence)name, (CharSequence)value);
        }

        public String remoteIp() {
            InetSocketAddress address = this.address();
            return address != null ? address.getHostString() : null;
        }

        public int remotePort() {
            InetSocketAddress address = this.address();
            return address != null ? address.getPort() : 0;
        }
    }

    private static abstract class AbstractTracingDoOnHandler {
        private static final Log log = LogFactory.getLog(AbstractTracingDoOnHandler.class);
        final ConfigurableApplicationContext context;
        HttpClientHandler handler;

        AbstractTracingDoOnHandler(ConfigurableApplicationContext context) {
            this.context = context;
        }

        HttpClientHandler handler() {
            if (this.handler == null) {
                this.handler = (HttpClientHandler)this.context.getBean(HttpClientHandler.class);
            }
            return this.handler;
        }

        void handle(Context context, @Nullable HttpClientResponse resp, @Nullable Throwable error) {
            AtomicReference<Span> pendingSpan = ReactorSleuth.getPendingSpan((ContextView)context);
            if (pendingSpan == null) {
                return;
            }
            Span span = pendingSpan.getAndSet(null);
            if (span == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handle receive of the netty client span [" + span + "]"));
            }
            HttpClientResponseWrapper response = new HttpClientResponseWrapper(resp, error);
            this.handler().handleReceive((org.springframework.cloud.sleuth.http.HttpClientResponse)response, span);
        }
    }

    private static class TracingDoOnErrorResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientResponse, Throwable> {
        TracingDoOnErrorResponse(ConfigurableApplicationContext context) {
            super(context);
        }

        @Override
        public void accept(HttpClientResponse response, Throwable error) {
            this.handle(response.currentContext(), response, error);
        }
    }

    private static class TracingDoOnErrorRequest
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientRequest, Throwable> {
        TracingDoOnErrorRequest(ConfigurableApplicationContext context) {
            super(context);
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientRequest req, Throwable error) {
            this.handle(req.currentContext(), null, error);
        }
    }

    private static class TracingDoOnResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientResponse, Connection> {
        TracingDoOnResponse(ConfigurableApplicationContext context) {
            super(context);
        }

        @Override
        public void accept(HttpClientResponse response, Connection connection) {
            this.handle(response.currentContext(), response, null);
        }
    }

    private static class TracingDoOnRequest
    implements BiConsumer<reactor.netty.http.client.HttpClientRequest, Connection> {
        private static final Log log = LogFactory.getLog(TracingDoOnRequest.class);
        final ConfigurableApplicationContext context;
        HttpClientHandler handler;

        TracingDoOnRequest(ConfigurableApplicationContext context) {
            this.context = context;
        }

        HttpClientHandler handler() {
            if (this.handler == null) {
                this.handler = (HttpClientHandler)this.context.getBean(HttpClientHandler.class);
            }
            return this.handler;
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientRequest req, Connection connection) {
            AtomicReference<Span> pendingSpan = ReactorSleuth.getPendingSpan(req.currentContextView());
            if (pendingSpan == null) {
                return;
            }
            Span span = pendingSpan.getAndSet(null);
            if (span != null) {
                span.abandon();
            }
            TraceContext parent = (TraceContext)req.currentContextView().getOrDefault(TraceContext.class, null);
            HttpClientRequestWrapper request = new HttpClientRequestWrapper(req, connection);
            span = this.handler().handleSend((HttpClientRequest)request, parent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handled send of the netty client span [" + span + "] with parent [" + parent + "]"));
            }
            pendingSpan.set(span);
        }
    }

    static class TracingMapConnect
    implements Function<Mono<? extends Connection>, Mono<? extends Connection>> {
        private static final Log log = LogFactory.getLog(TracingMapConnect.class);
        static final Exception CANCELLED_ERROR = new CancellationException("CANCELLED"){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        final Supplier<TraceContext> currentTraceContext;

        TracingMapConnect(Supplier<TraceContext> currentTraceContext) {
            this.currentTraceContext = currentTraceContext;
        }

        @Override
        public Mono<? extends Connection> apply(Mono<? extends Connection> mono) {
            PendingSpan pendingSpan = new PendingSpan();
            return mono.contextWrite(context -> {
                TraceContext invocationContext = this.currentTraceContext.get();
                if (invocationContext != null) {
                    context = ReactorSleuth.wrapContext(context.put(TraceContext.class, (Object)invocationContext));
                }
                return ReactorSleuth.putPendingSpan(context, pendingSpan);
            }).doOnCancel(() -> {
                Span span = pendingSpan.getAndSet(null);
                if (span != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Marking span [" + span + "] with cancelled error"));
                    }
                    span.error((Throwable)CANCELLED_ERROR);
                    span.end();
                }
            });
        }
    }

    static final class PendingSpan
    extends AtomicReference<Span> {
        PendingSpan() {
        }
    }
}

